/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class ImageCanvas
extends Canvas {
    protected int width = this.getWidth();
    protected int height = this.getHeight();
    protected int scrollPixels = 5;
    protected int offsetX;
    protected int offsetY;
    protected Image image;

    ImageCanvas() {
    }

    void setImage(Image image) {
        this.image = image;
        this.offsetX = 0;
        this.offsetY = 0;
    }

    protected void keyPressed(int n) {
        this.processKey(n);
    }

    protected void keyRepeated(int n) {
        this.processKey(n);
    }

    protected void processKey(int n) {
        n = this.getGameAction(n);
        switch (n) {
            case 1: {
                this.offsetY += this.scrollPixels;
                break;
            }
            case 6: {
                this.offsetY -= this.scrollPixels;
                break;
            }
            case 2: {
                this.offsetX += this.scrollPixels;
                break;
            }
            case 5: {
                this.offsetX -= this.scrollPixels;
            }
        }
        if (this.offsetX < this.width - this.image.getWidth()) {
            this.offsetX = this.width - this.image.getWidth();
        }
        if (this.offsetY < this.height - this.image.getHeight()) {
            this.offsetY = this.height - this.image.getHeight();
        }
        if (this.offsetX > 0) {
            this.offsetX = 0;
        }
        if (this.offsetY > 0) {
            this.offsetY = 0;
        }
        this.repaint();
    }

    protected void paint(Graphics graphics) {
        graphics.fillRect(0, 0, this.width, this.height);
        if (this.image != null) {
            graphics.drawImage(this.image, this.offsetX, this.offsetY, 20);
        }
    }
}

