/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import com.nokia.mid.ui.FullCanvas;
import java.io.IOException;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameCanvas
extends FullCanvas {
    private static final int SPRITES = 20;
    private static final int DELAY = 50;
    private static final int BLOCK_WIDTH = 6;
    private static final int BLOCK_HEIGHT = 5;
    private static final int START_LEVEL = 0;
    private static final int ELEVATOR_PAUSE = 4;
    int width;
    int height;
    int gameState;
    int gameTicker;
    int score;
    int level;
    int lives;
    int timeLeft;
    int timerDelay;
    int timerLeftCnt;
    int spritesInLevel;
    int spritesLeft;
    int linksFnd;
    int cursorX;
    int cursorY;
    int cursorFFtmr;
    int cursorHoldingIX;
    int keyLast = -1;
    int bannerCx;
    int bannerCy;
    int bannerFIX;
    int bannerYoff;
    int bannerHeight;
    int elevatorPause;
    int[] bannerFloat = new int[]{-3, -3, -3, -3, -2, -2, -1, 0, 1, 2, 2, 3, 3, 3, 3, 2, 2, 1, 0, -1, -2, -2};
    boolean cursorHolding = false;
    boolean cursorFF = false;
    boolean cursorOn;
    boolean cursorFalling;
    boolean timerLeftFF;
    boolean running = false;
    boolean keyUp;
    boolean keyDown;
    boolean keyLeft;
    boolean keyRight;
    boolean keyFire;
    boolean keyStar;
    boolean bannerOn = false;
    long time;
    private GameLoop gameLoop;
    Display display;
    BlokDown blokDown;
    ScoreList scoreList;
    Image gameArt;
    Image buffer;
    Image smallText;
    Image bigText;
    Image digit;
    Image banner;
    Image titleImg;
    Graphics bufferG;
    Graphics smallTextG;
    Graphics bigTextG;
    Graphics digitG;
    Graphics bannerG;
    Graphics titleImgG;
    DirectGraphics bufferDG;
    Sprite[] sprite = new Sprite[20];
    Sprite elevator;
    private int[] map = new int[120];
    private static String validChars = "0123456789abcdefghijklmnopqrstuvwxyz.,!?";
    private int[] charWidth = new int[]{6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 3, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 4, 4, 3, 6};
    int[] nameTxt = new int[]{10, 10, 10, 10, 10};
    int nameCurPos = 0;

    GameCanvas(Display display, BlokDown blokDown) {
        this.blokDown = blokDown;
        this.display = display;
        this.width = this.getWidth();
        this.height = this.getHeight();
        Sprite.screenWidth = this.width;
        Sprite.screenHeight = this.height;
        this.scoreList = new ScoreList();
        this.buffer = Image.createImage((int)this.width, (int)this.height);
        this.bufferG = this.buffer.getGraphics();
        this.bufferDG = DirectUtils.getDirectGraphics((Graphics)this.bufferG);
        this.smallText = Image.createImage((int)100, (int)10);
        this.smallTextG = this.smallText.getGraphics();
        this.bigText = Image.createImage((int)88, (int)32);
        this.bigTextG = this.bigText.getGraphics();
        this.digit = Image.createImage((int)50, (int)9);
        this.digitG = this.digit.getGraphics();
        this.titleImg = Image.createImage((int)74, (int)45);
        this.titleImgG = this.titleImg.getGraphics();
        this.banner = DirectUtils.createImage((int)97, (int)111, (int)0);
        this.bannerG = this.banner.getGraphics();
        try {
            this.gameArt = Image.createImage((String)("/g" + (this.display.isColor() ? "2" : "") + ".png"));
        }
        catch (IOException iOException) {
            System.out.println("Unable to load image!!");
        }
        int n = 0;
        while (n < 20) {
            this.sprite[n] = new Sprite(6, 5, 16, 1, this.gameArt);
            ++n;
        }
        this.elevator = this.sprite[Sprite.totalSprites - 1];
        this.digitG.drawImage(this.gameArt, 0, -15, 20);
        this.bannerG.drawImage(this.gameArt, 0, -45, 20);
        this.bigTextG.drawImage(this.gameArt, 0, -201, 20);
        this.smallTextG.drawImage(this.gameArt, 0, -5, 20);
        this.titleImgG.drawImage(this.gameArt, 0, -156, 20);
    }

    void showTitle(int n) {
        this.clearBuffer();
        this.bufferG.setClip((this.width - 88) / 2, 0, 88, 8);
        this.bufferDG.drawImage(this.bigText, (this.width - 88) / 2, -(n << 3), 20, 0);
        this.bufferG.setClip(0, 0, this.width + 1, this.height + 1);
        this.bufferG.setColor(0);
        this.bufferG.drawLine(0, 9, this.width, 9);
    }

    void drawText(int n, int n2, String string) {
        int n3 = n;
        int n4 = 0;
        string = string + "\n";
        int n5 = string.indexOf("\n", n4);
        while (n5 > -1) {
            int n6;
            int n7;
            String string2 = string.substring(n4, n5);
            n4 = n5 + 1;
            if (n == -1) {
                int n8 = 0;
                n7 = 0;
                while (n7 < string2.length()) {
                    n5 = validChars.indexOf(string2.charAt(n7));
                    n8 += n5 > -1 ? this.charWidth[n5] : 3;
                    ++n7;
                }
                n6 = (this.width - n8) / 2;
            } else {
                n6 = n3;
            }
            n7 = 0;
            while (n7 < string2.length()) {
                n5 = validChars.indexOf(string2.charAt(n7));
                if (n5 > -1) {
                    this.drawChar(n6, n2, n5);
                }
                n6 += n5 > -1 ? this.charWidth[n5] : 3;
                ++n7;
            }
            n2 += 6;
            n5 = string.indexOf("\n", n4);
        }
        this.bufferG.setClip(0, 0, this.width + 1, this.height + 1);
    }

    void drawChar(int n, int n2, int n3) {
        int n4 = n3 % 20 * 5;
        int n5 = n3 / 20 * 5;
        this.bufferG.setClip(n, n2, 5, 5);
        this.bufferDG.drawImage(this.smallText, n - n4, n2 - n5, 20, 0);
    }

    void setBanner(int n) {
        this.bannerHeight = n < 6 ? 22 : 44;
        this.bannerOn = true;
        this.bannerCy = n / 2 * 22;
        this.bannerCx = (n & 1) * 48;
        this.bannerYoff = -(this.height / 2 + (this.bannerHeight - 22));
        this.bannerFIX = 7;
    }

    void clearBanner() {
        this.bannerYoff = 4;
    }

    void setGameState(int n) {
        this.gameState = n;
        this.gameTicker = 0;
        if (!this.running) {
            this.gameLoop = new GameLoop();
            this.gameLoop.start();
            this.running = true;
        }
        this.keyFire = false;
        this.keyRight = false;
        this.keyLeft = false;
        this.keyDown = false;
        this.keyUp = false;
    }

    public void drawTimeLeft() {
        this.drawNumber(this.width - 22, 10, this.timeLeft / 60, 1);
        this.drawNumber(this.width - 14, 10, this.timeLeft % 60, 2);
    }

    public void drawScore() {
        this.drawNumber(this.width - 32, 32, this.score, 5);
    }

    public void drawLevel() {
        this.drawNumber(this.width - 14, 54, this.level + 1, 2);
    }

    public void drawNumber(int n, int n2, int n3, int n4) {
        n += 6 * (n4 - 1);
        int n5 = 0;
        while (n5 < n4) {
            this.bufferG.setClip(n, n2, 5, 9);
            this.bufferDG.drawImage(this.digit, n - n3 % 10 * 5, n2, 20, 0);
            n3 /= 10;
            n -= 6;
            ++n5;
        }
        this.bufferG.setClip(0, 0, this.width, this.height);
    }

    public void clearBuffer() {
        this.bufferG.setClip(0, 0, this.width + 1, this.height + 1);
        this.bufferG.setColor(0xFFFFFF);
        this.bufferG.fillRect(0, 0, this.width, this.height);
    }

    public void drawGameScreen() {
        this.clearBuffer();
        int n = 0;
        while (n < 3) {
            this.bufferG.setClip(this.width - 35, n * 22, 35, 21);
            this.bufferDG.drawImage(this.gameArt, this.width - 35, -24 + n * 22, 20, 0);
            ++n;
        }
        this.bufferG.setClip(this.width - 35, 22, 35, 9);
        this.bufferDG.drawImage(this.gameArt, this.width - 70, -2, 20, 0);
        this.bufferG.setClip(this.width - 35, 44, 35, 9);
        this.bufferDG.drawImage(this.gameArt, this.width - 70, 11, 20, 0);
        this.bufferG.setClip(0, 0, this.width, this.height);
        this.drawTimeLeft();
        this.drawScore();
        this.drawLevel();
    }

    public int getMap(int n, int n2) {
        return this.map[n / 6 + n2 / 5 * 10];
    }

    public void cursorReset() {
        this.cursorX = 0;
        this.cursorY = 0;
        this.cursorOn = false;
        this.cursorHolding = false;
        this.cursorHoldingIX = -1;
        this.cursorFalling = false;
        this.cursorFF = false;
        this.cursorFFtmr = 3;
    }

    public void cursorMoveBy(int n, int n2) {
        if (this.cursorX % 6 > 0 || this.cursorY % 5 > 0 || this.cursorHolding && n2 != 0) {
            return;
        }
        if ((n += this.cursorX) < 0 || (n2 += this.cursorY) < 0 || n / 6 > 9 || n2 / 5 > 11 || this.getMap(n, n2) == 54 || n % 6 > 0 || n2 % 5 > 0 || this.cursorHolding && (this.getMap(n, n2) > 0 || this.cursorFalling)) {
            return;
        }
        if (this.cursorHolding) {
            int n3 = 0;
            while (n3 < Sprite.totalSprites) {
                if (this.sprite[n3].on && this.sprite[n3].pixelWithin(n + 3, n2 + 2)) {
                    return;
                }
                ++n3;
            }
            this.cursorX = n;
            this.cursorY = n2;
            this.keyRight = false;
            this.keyLeft = false;
            this.keyDown = false;
            this.keyUp = false;
            this.sprite[this.cursorHoldingIX].x = this.cursorX;
            this.sprite[this.cursorHoldingIX].y = this.cursorY;
        } else {
            this.cursorX = n;
            this.cursorY = n2;
            this.keyRight = false;
            this.keyLeft = false;
            this.keyDown = false;
            this.keyUp = false;
        }
    }

    public void cursorPick() {
        if (this.cursorHolding) {
            this.cursorHolding = false;
            this.cursorX = this.cursorX / 6 * 6;
            this.cursorY = this.cursorY / 5 * 5;
            return;
        }
        int n = 0;
        while (n < Sprite.totalSprites - 1) {
            if (this.sprite[n].pixelWithin(this.cursorX + 3, this.cursorY + 2)) {
                this.cursorHoldingIX = n;
                this.cursorHolding = true;
                this.cursorX = this.sprite[n].x;
                this.cursorY = this.sprite[n].y;
                return;
            }
            ++n;
        }
    }

    public void drawRack(boolean bl) {
        int n = 0;
        int n2 = -5;
        boolean bl2 = true;
        this.bufferG.setColor(0xFFFFFF);
        this.bufferG.fillRect(0, this.height / 2 - 35, 60, 70);
        this.bufferG.setColor(0);
        this.cursorReset();
        this.spritesInLevel = 0;
        int n3 = 0;
        while (n3 < 20) {
            this.sprite[n3].reset();
            ++n3;
        }
        this.elevatorPause = 0;
        n3 = 0;
        while (n3 < 120) {
            int n4;
            if (n3 % 10 == 0) {
                n = 0;
                n2 += 5;
            }
            this.map[n3] = n4 = this.blokDown.rack[this.level].charAt(n3) - 48;
            if (n4 == 1) {
                this.bufferG.fillRect(n, n2, 6, 5);
                if (bl2) {
                    bl2 = false;
                    this.cursorX = n;
                    this.cursorY = n2;
                    this.cursorOn = true;
                    this.cursorHolding = false;
                }
            } else if (n4 < 10 && n4 > 0) {
                Sprite sprite = this.sprite[this.spritesInLevel++];
                sprite.setFrame(n4 - 1);
                sprite.moveTo(n, n2);
                sprite.on = true;
                this.map[n3] = 0;
            } else if (n4 > 10 && n4 < 54) {
                this.map[n3] = 0;
                switch (n4) {
                    case 50: {
                        this.elevator.setDirection(1, 0);
                        break;
                    }
                    case 51: {
                        this.elevator.setDirection(-1, 0);
                        break;
                    }
                    case 52: {
                        this.elevator.setDirection(0, 1);
                        break;
                    }
                    case 53: {
                        this.elevator.setDirection(0, -1);
                    }
                }
                this.elevator.moveTo(n, n2);
                this.elevator.on = true;
            }
            n += 6;
            ++n3;
        }
        this.spritesLeft = this.spritesInLevel;
        if (bl) {
            this.timeLeft = this.blokDown.rackTime[this.level];
        }
        this.timerDelay = 20;
        this.timerLeftCnt = 2;
        this.timerLeftFF = true;
        this.drawTimeLeft();
        this.drawLevel();
        this.clearKeys();
    }

    public void clearKeys() {
        this.keyStar = false;
        this.keyFire = false;
        this.keyRight = false;
        this.keyLeft = false;
        this.keyDown = false;
        this.keyUp = false;
        this.keyLast = -1;
    }

    protected void paint(Graphics graphics) {
        DirectGraphics directGraphics = DirectUtils.getDirectGraphics((Graphics)graphics);
        directGraphics.drawImage(this.buffer, 0, 0, 20, 0);
        switch (this.gameState) {
            case 2: {
                this.playing(graphics);
            }
        }
        if (this.cursorOn) {
            this.drawCursor(graphics);
        }
        if (this.bannerOn) {
            int n;
            int n2 = (this.width - 83) / 2;
            if (this.bannerYoff < 0) {
                n = (this.height - this.bannerHeight) / 2 + this.bannerYoff;
                this.bannerYoff += 4;
                if (this.bannerYoff > 0) {
                    this.bannerYoff = 0;
                }
            } else if (this.bannerYoff > 0) {
                n = (this.height - this.bannerHeight) / 2 + this.bannerYoff + this.bannerFloat[this.bannerFIX];
                this.bannerYoff += 4;
                if (this.bannerYoff > this.height) {
                    this.bannerOn = false;
                }
            } else {
                n = this.bannerFloat[this.bannerFIX++] + (this.height - this.bannerHeight) / 2;
            }
            if (this.bannerFIX == this.bannerFloat.length) {
                this.bannerFIX = 0;
            }
            graphics.setClip(n2, n, 49, this.bannerHeight + 1);
            directGraphics.drawImage(this.banner, n2 - this.bannerCx, n - this.bannerCy, 20, 0);
            graphics.setClip(0, 0, this.width, this.height);
        }
    }

    public void playing(Graphics graphics) {
        this.cursorFalling = false;
        if (this.elevator.on) {
            this.checkElevator();
            this.elevator.paint(graphics);
        }
        int n = 0;
        while (n < this.spritesInLevel) {
            if (this.sprite[n].on) {
                if (this.sprite[n].frame > 13) {
                    this.sprite[n].on = false;
                    this.sprite[n].x = -100;
                    if (this.cursorHolding && this.cursorHoldingIX == n) {
                        this.cursorPick();
                    }
                }
                if (n < 19) {
                    this.checkSprite(this.sprite[n]);
                }
            }
            ++n;
        }
        n = 0;
        while (n < this.spritesInLevel) {
            if (this.sprite[n].on) {
                if (n < 19 && this.sprite[n].frame < 8 && this.sprite[n].x % 6 == 0 && this.sprite[n].y % 5 == 0 && !this.sprite[n].falling) {
                    this.checkLink(this.sprite[n], 0, this.sprite[n].frame);
                    if (this.linksFnd > 0) {
                        this.score += 10 * (this.linksFnd * this.linksFnd * 2);
                        this.spritesLeft -= this.linksFnd + 1;
                        this.drawScore();
                        if (this.spritesLeft == 0) {
                            this.setGameState(6);
                        }
                    }
                }
                this.sprite[n].paint(graphics);
                if (this.sprite[n].frame > 7) {
                    ++this.sprite[n].frame;
                }
            }
            ++n;
        }
        graphics.setClip(0, 0, this.width, this.height);
        if (this.timeLeft < 25) {
            if (--this.timerLeftCnt == 0) {
                this.timerLeftCnt = this.timeLeft > 15 ? 3 : (this.timeLeft > 8 ? 2 : 1);
                boolean bl = this.timerLeftFF = !this.timerLeftFF;
            }
            if (this.timerLeftFF) {
                graphics.setColor(this.display.isColor() ? 0xFFFF84 : 0xFFFFFF);
                graphics.fillRect(this.width - 32, 2, 30, 8);
            }
        }
    }

    public void drawCursor(Graphics graphics) {
        if (this.cursorFFtmr-- == 0) {
            this.cursorFF = !this.cursorFF;
            this.cursorFFtmr = 3;
        }
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(this.cursorX + 5, this.cursorY + 4, 4, 4);
        graphics.fillRect(this.cursorX + 8, this.cursorY + 7, 3, 3);
        graphics.setColor(0);
        graphics.drawLine(this.cursorX + 4, this.cursorY + 3, this.cursorX + 10, this.cursorY + 3);
        graphics.drawLine(this.cursorX + 4, this.cursorY + 3, this.cursorX + 4, this.cursorY + 9);
        graphics.drawLine(this.cursorX + 5, this.cursorY + 8, this.cursorX + 6, this.cursorY + 7);
        graphics.drawLine(this.cursorX + 7, this.cursorY + 8, this.cursorX + 9, this.cursorY + 10);
        graphics.drawLine(this.cursorX + 10, this.cursorY + 9, this.cursorX + 11, this.cursorY + 8);
        graphics.drawLine(this.cursorX + 10, this.cursorY + 7, this.cursorX + 8, this.cursorY + 5);
        graphics.drawLine(this.cursorX + 9, this.cursorY + 4, this.cursorX + 9, this.cursorY + 4);
        if (this.cursorHolding) {
            graphics.setColor(this.cursorFF ? 0xFFFFFF : 0);
            this.cursorX = this.sprite[this.cursorHoldingIX].x;
            this.cursorY = this.sprite[this.cursorHoldingIX].y;
            graphics.drawRect(this.cursorX - 1, this.cursorY - 1, 7, 6);
        }
    }

    public void checkElevator() {
        boolean bl = true;
        if (this.elevatorPause > 0) {
            --this.elevatorPause;
        }
        if (this.elevator.xDir == 0) {
            if (this.elevatorPause == 0) {
                this.elevator.y += this.elevator.yDir;
            }
            int n = this.elevator.y - 2;
            while (n > 0) {
                bl = true;
                if (this.getMap(this.elevator.x + 3, n + 1) > 0) {
                    bl = false;
                    break;
                }
                int n2 = 0;
                while (n2 < this.spritesInLevel) {
                    if (this.sprite[n2].pixelWithin(this.elevator.x + 3, n)) {
                        this.sprite[n2].y = n - 3;
                        bl = false;
                        break;
                    }
                    ++n2;
                }
                if (bl) break;
                n -= 5;
            }
            if (this.elevator.yDir == 1) {
                if (this.getMap(this.elevator.x, this.elevator.y + 5) > 0) {
                    this.elevator.yDir = -1;
                    this.elevatorPause = 4;
                } else {
                    n = 0;
                    while (n < this.spritesInLevel) {
                        if (this.sprite[n].pixelWithin(this.elevator.x + 3, this.elevator.y + 5)) {
                            this.elevator.yDir = -1;
                            break;
                        }
                        ++n;
                    }
                }
            } else if (this.elevator.yDir == -1 && !bl) {
                this.elevator.yDir = 1;
                this.elevatorPause = 4;
            }
        } else {
            if (this.elevatorPause == 0) {
                this.elevator.x += this.elevator.xDir;
            }
            int n = this.elevator.y - 2;
            while (n > 0) {
                bl = true;
                if (this.getMap(this.elevator.x + 3, n + 1) > 0) break;
                int n3 = 0;
                while (n3 < this.spritesInLevel) {
                    if (this.sprite[n3].pixelWithin(this.elevator.x + 3, n)) {
                        this.sprite[n3].y = n - 3;
                        if (this.elevator.xDir == 1 && this.getMap(this.sprite[n3].x + 6, this.sprite[n3].y) == 0 && this.noSprite(this.sprite[n3].x + 6, this.sprite[n3].y, this.sprite[n3].ix)) {
                            this.sprite[n3].x = this.elevator.x;
                        }
                        if (this.elevator.xDir == -1 && this.getMap(this.sprite[n3].x - 1, this.sprite[n3].y) == 0 && this.noSprite(this.sprite[n3].x - 1, this.sprite[n3].y, this.sprite[n3].ix)) {
                            this.sprite[n3].x = this.elevator.x;
                        }
                        bl = false;
                        break;
                    }
                    if (this.elevator.xDir == -1 && this.sprite[n3].pixelWithin(this.elevator.x - 1, this.elevator.y + 2)) {
                        this.elevator.xDir = 1;
                        this.elevatorPause = 4;
                    } else if (this.elevator.xDir == 1 && this.sprite[n3].pixelWithin(this.elevator.x + 6, this.elevator.y + 2)) {
                        this.elevator.xDir = -1;
                        this.elevatorPause = 4;
                    }
                    ++n3;
                }
                if (bl) break;
                n -= 5;
            }
            if (this.elevator.xDir == 1) {
                if (this.getMap(this.elevator.x + 6, this.elevator.y) > 0) {
                    this.elevator.xDir = -1;
                    this.elevatorPause = 4;
                }
            } else if (this.getMap(this.elevator.x - 1, this.elevator.y) > 0) {
                this.elevator.xDir = 1;
                this.elevatorPause = 4;
            }
        }
    }

    public void checkLink(Sprite sprite, int n, int n2) {
        if (n == 0) {
            this.linksFnd = 0;
        }
        if (++n > 2) {
            return;
        }
        int n3 = 0;
        while (n3 < this.spritesInLevel) {
            if (this.sprite[n3].on && this.sprite[n3].frame == n2 && !this.sprite[n3].falling && this.sprite[n3].ix != sprite.ix && this.sprite[n3].x % 6 == 0 && this.sprite[n3].y % 5 == 0 && (this.sprite[n3].pixelWithin(sprite.x + 3, sprite.y + 9) || this.sprite[n3].pixelWithin(sprite.x + 3, sprite.y - 4) || this.sprite[n3].pixelWithin(sprite.x + 10, sprite.y + 2) || this.sprite[n3].pixelWithin(sprite.x - 5, sprite.y + 2))) {
                sprite.frame = 8;
                this.sprite[n3].frame = 8;
                ++this.linksFnd;
                this.checkLink(this.sprite[n3], n, n2);
            }
            ++n3;
        }
    }

    private boolean noSprite(int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < this.spritesInLevel) {
            if (n4 != n3 && this.sprite[n4].pixelWithin(n, n2)) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    private void checkSprite(Sprite sprite) {
        sprite.falling = false;
        int n = this.map[sprite.x / 6 + (sprite.y + 5) / 5 * 10];
        if (n == 1) {
            if (sprite.y % 5 == 1) {
                --sprite.y;
            }
            return;
        }
        int n2 = 0;
        while (n2 < this.spritesInLevel) {
            if (this.sprite[n2].on && n2 != sprite.ix && this.sprite[n2].pixelWithin(sprite.x + 3, sprite.y + 5)) {
                sprite.y = this.sprite[n2].y - 5;
                return;
            }
            ++n2;
        }
        if (this.elevator.on && this.elevator.pixelWithin(sprite.x + 3, sprite.y + 6)) {
            sprite.y = this.elevator.y - 5;
            return;
        }
        if (this.cursorHolding && this.cursorHoldingIX == sprite.ix) {
            this.cursorFalling = true;
        }
        sprite.y += 2;
        sprite.falling = true;
    }

    public void keyReleased(int n) {
        if (this.gameState != 2) {
            this.keyRight = false;
            this.keyLeft = false;
            this.keyDown = false;
            this.keyUp = false;
            this.keyFire = false;
        }
    }

    public void keyPressed(int n) {
        switch (this.getGameAction(n)) {
            case 1: {
                this.keyUp = true;
                break;
            }
            case 6: {
                this.keyDown = true;
                break;
            }
            case 2: {
                this.keyLeft = true;
                break;
            }
            case 5: {
                this.keyRight = true;
                break;
            }
            case 8: {
                this.keyFire = true;
                break;
            }
            default: {
                this.keyLast = n;
            }
        }
    }

    public class GameLoop
    extends Thread {
        public void run() {
            while (GameCanvas.this.gameState > 0) {
                GameCanvas.this.time = System.currentTimeMillis();
                switch (GameCanvas.this.gameState) {
                    case 1: {
                        if (GameCanvas.this.gameTicker++ != 0) break;
                        GameCanvas.this.score = 0;
                        GameCanvas.this.lives = 2;
                        GameCanvas.this.level = 0;
                        GameCanvas.this.timeLeft = 0;
                        GameCanvas.this.drawGameScreen();
                        GameCanvas.this.setGameState(2);
                        break;
                    }
                    case 2: {
                        if (GameCanvas.this.gameTicker++ == 0) {
                            GameCanvas.this.drawRack(true);
                        }
                        if (GameCanvas.this.keyUp) {
                            GameCanvas.this.cursorMoveBy(0, -5);
                        }
                        if (GameCanvas.this.keyDown) {
                            GameCanvas.this.cursorMoveBy(0, 5);
                        }
                        if (GameCanvas.this.keyLeft) {
                            GameCanvas.this.cursorMoveBy(-6, 0);
                        }
                        if (GameCanvas.this.keyRight) {
                            GameCanvas.this.cursorMoveBy(6, 0);
                        }
                        GameCanvas.this.keyRight = false;
                        GameCanvas.this.keyLeft = false;
                        GameCanvas.this.keyDown = false;
                        GameCanvas.this.keyUp = false;
                        if (GameCanvas.this.keyFire) {
                            GameCanvas.this.cursorPick();
                        }
                        if (GameCanvas.this.keyLast == 42) {
                            GameCanvas.this.setGameState(7);
                        }
                        GameCanvas.this.keyLast = -1;
                        GameCanvas.this.keyFire = false;
                        if (--GameCanvas.this.timerDelay != 0) break;
                        --GameCanvas.this.timeLeft;
                        GameCanvas.this.drawTimeLeft();
                        GameCanvas.this.timerDelay = 20;
                        if (GameCanvas.this.timeLeft != 0) break;
                        GameCanvas.this.setGameState(3);
                        break;
                    }
                    case 3: {
                        if (GameCanvas.this.gameTicker++ == 0) {
                            GameCanvas.this.cursorReset();
                            int n = 0;
                            while (n < GameCanvas.this.spritesInLevel) {
                                GameCanvas.this.sprite[n].reset();
                                ++n;
                            }
                            GameCanvas.this.setBanner(0);
                            break;
                        }
                        if (GameCanvas.this.gameTicker == 50) {
                            GameCanvas.this.clearBanner();
                            break;
                        }
                        if (GameCanvas.this.bannerOn) break;
                        GameCanvas.this.setGameState(4);
                        break;
                    }
                    case 4: {
                        if (GameCanvas.this.gameTicker++ == 0) {
                            GameCanvas.this.cursorReset();
                            GameCanvas.this.bufferG.setColor(0xFFFFFF);
                            GameCanvas.this.setBanner(GameCanvas.this.lives == 2 ? 2 : (GameCanvas.this.lives == 1 ? 3 : 4));
                            break;
                        }
                        if (GameCanvas.this.lives == 0 && GameCanvas.this.gameTicker < 50) {
                            GameCanvas.this.bufferG.fillRect(0, GameCanvas.this.height / 2 - GameCanvas.this.gameTicker, 60, GameCanvas.this.gameTicker << 1);
                            break;
                        }
                        if (GameCanvas.this.gameTicker == 50) {
                            GameCanvas.this.clearBanner();
                            break;
                        }
                        if (GameCanvas.this.bannerOn) break;
                        GameCanvas.this.setGameState(GameCanvas.this.lives-- == 0 ? 5 : 2);
                        break;
                    }
                    case 5: {
                        if (GameCanvas.this.gameTicker++ == 0) {
                            if (GameCanvas.this.score > GameCanvas.this.scoreList.getScore(4)) {
                                GameCanvas.this.setBanner(5);
                                break;
                            }
                            GameCanvas.this.setGameState(10);
                            break;
                        }
                        if (GameCanvas.this.gameTicker == 50) {
                            GameCanvas.this.clearBanner();
                            GameCanvas.this.showTitle(2);
                            GameCanvas.this.cursorOn = true;
                            GameCanvas.this.cursorY = 17;
                            int n = 0;
                            while (n < 5) {
                                GameCanvas.this.nameTxt[n] = 10;
                                ++n;
                            }
                            GameCanvas.this.nameCurPos = 0;
                            GameCanvas.this.drawText(-1, 28, "use up, down,\nleft and right to\nchange letters.\n\npress select\nwhen done!");
                            GameCanvas.this.drawText(-1, 14, "aaaaa");
                            GameCanvas.this.clearKeys();
                            break;
                        }
                        if (GameCanvas.this.gameTicker <= 50) break;
                        if (GameCanvas.this.keyUp && GameCanvas.this.nameTxt[GameCanvas.this.nameCurPos] < 38) {
                            int n = GameCanvas.this.nameCurPos;
                            GameCanvas.this.nameTxt[n] = GameCanvas.this.nameTxt[n] + 1;
                        }
                        if (GameCanvas.this.keyDown && GameCanvas.this.nameTxt[GameCanvas.this.nameCurPos] > 0) {
                            int n = GameCanvas.this.nameCurPos;
                            GameCanvas.this.nameTxt[n] = GameCanvas.this.nameTxt[n] - 1;
                        }
                        if (GameCanvas.this.keyLeft && GameCanvas.this.nameCurPos > 0) {
                            --GameCanvas.this.nameCurPos;
                        }
                        if (GameCanvas.this.keyRight && GameCanvas.this.nameCurPos < 4) {
                            ++GameCanvas.this.nameCurPos;
                        }
                        if (GameCanvas.this.keyFire) {
                            String string = "";
                            int n = 0;
                            while (n < 5) {
                                string = string + validChars.charAt(GameCanvas.this.nameTxt[n]);
                                ++n;
                            }
                            GameCanvas.this.scoreList.setNewScore(GameCanvas.this.score, string);
                            GameCanvas.this.setGameState(11);
                            GameCanvas.this.cursorReset();
                        }
                        GameCanvas.this.drawChar(GameCanvas.this.width / 2 - 15 + GameCanvas.this.nameCurPos * 6, 14, GameCanvas.this.nameTxt[GameCanvas.this.nameCurPos]);
                        GameCanvas.this.cursorX = GameCanvas.this.width / 2 - 15 + GameCanvas.this.nameCurPos * 6;
                        GameCanvas.this.clearKeys();
                        break;
                    }
                    case 6: {
                        if (GameCanvas.this.gameTicker++ == 0) {
                            GameCanvas.this.cursorReset();
                            GameCanvas.this.setBanner(1);
                            break;
                        }
                        if (GameCanvas.this.gameTicker == 50) {
                            GameCanvas.this.clearBanner();
                            break;
                        }
                        if (!GameCanvas.this.bannerOn) {
                            ++GameCanvas.this.level;
                            if (GameCanvas.this.level < GameCanvas.this.blokDown.rack.length) {
                                GameCanvas.this.setGameState(2);
                                break;
                            }
                            GameCanvas.this.setGameState(14);
                            break;
                        }
                        if (GameCanvas.this.gameTicker <= 10 || GameCanvas.this.timeLeft <= 0) break;
                        GameCanvas.this.timeLeft = GameCanvas.this.timeLeft - (GameCanvas.this.timeLeft >= 3 ? 3 : GameCanvas.this.timeLeft);
                        GameCanvas.this.score += 15;
                        GameCanvas.this.drawTimeLeft();
                        GameCanvas.this.drawScore();
                        break;
                    }
                    case 7: {
                        if (GameCanvas.this.gameTicker++ == 0) {
                            GameCanvas.this.setBanner(6);
                        }
                        if (GameCanvas.this.keyLast == 49) {
                            GameCanvas.this.setGameState(8);
                        }
                        if (GameCanvas.this.keyLast == 55) {
                            GameCanvas.this.setGameState(9);
                        }
                        if (GameCanvas.this.keyLast != 57) break;
                        GameCanvas.this.clearBanner();
                        GameCanvas.this.setGameState(10);
                        break;
                    }
                    case 8: {
                        if (GameCanvas.this.gameTicker++ == 0) {
                            GameCanvas.this.clearBanner();
                        }
                        if (GameCanvas.this.bannerOn) break;
                        GameCanvas.this.gameState = 2;
                        break;
                    }
                    case 9: {
                        if (GameCanvas.this.gameTicker++ == 0) {
                            GameCanvas.this.clearBanner();
                        }
                        if (GameCanvas.this.bannerOn) break;
                        GameCanvas.this.drawRack(false);
                        GameCanvas.this.gameState = 2;
                        break;
                    }
                    case 10: {
                        if (GameCanvas.this.gameTicker++ == 0) {
                            GameCanvas.this.cursorReset();
                            GameCanvas.this.clearBuffer();
                            GameCanvas.this.cursorY = -45;
                            GameCanvas.this.cursorX = (GameCanvas.this.width - 74) / 2;
                        } else if (GameCanvas.this.gameTicker < 100 && GameCanvas.this.cursorX < (GameCanvas.this.width - 74) / 2 + 74) {
                            GameCanvas.this.bufferG.setClip(GameCanvas.this.cursorX, 0, 8, GameCanvas.this.height + 1);
                            GameCanvas.this.bufferG.setColor(0xFFFFFF);
                            GameCanvas.this.bufferG.fillRect(GameCanvas.this.cursorX, GameCanvas.this.cursorY - 8, 8, 8);
                            GameCanvas.this.bufferDG.drawImage(GameCanvas.this.titleImg, (GameCanvas.this.width - 74) / 2, GameCanvas.this.cursorY, 20, 0);
                            GameCanvas.this.cursorY += 8;
                            if (GameCanvas.this.cursorY > (GameCanvas.this.height - 45) / 2 + 4) {
                                GameCanvas.this.cursorY = -45;
                                GameCanvas.this.cursorX += 8;
                            }
                        } else if (GameCanvas.this.gameTicker == 120) {
                            GameCanvas.this.showTitle(0);
                            int n = 0;
                            while (n < 5) {
                                GameCanvas.this.cursorX = GameCanvas.this.scoreList.getScore(n);
                                GameCanvas.this.drawText(GameCanvas.this.width / 2 - 35, (n << 3) + 15, GameCanvas.this.scoreList.getName(n));
                                GameCanvas.this.drawText(GameCanvas.this.width / 2 + 5, (n << 3) + 15, (GameCanvas.this.cursorX > 9999 ? "" : "0") + (GameCanvas.this.cursorX > 999 ? "" : "0") + (GameCanvas.this.cursorX > 99 ? "" : "0") + (GameCanvas.this.cursorX > 9 ? "" : "0") + GameCanvas.this.cursorX);
                                ++n;
                            }
                        } else if (GameCanvas.this.gameTicker == 200) {
                            GameCanvas.this.showTitle(1);
                            GameCanvas.this.drawText(-1, 15, "drag blocks about\nlevels to make 2\nor more of a\nsingle type touch\nto clear them.\nclear all blocks\nwithin time limit!");
                        } else if (GameCanvas.this.gameTicker == 320) {
                            GameCanvas.this.showTitle(1);
                            GameCanvas.this.drawText(-1, 15, "you can only\ndrag blocks left\nor right. to grab\na block, move the\ncursor to block\nand hit 5.\npress 5 again\nto release block.");
                        } else if (GameCanvas.this.gameTicker == 440) {
                            GameCanvas.this.showTitle(1);
                            GameCanvas.this.drawText(-1, 15, "press the star\nkey for options\nat any time!\nyou may need to\nuse this to retry\na level if you\nscrew up during\na game!");
                        } else if (GameCanvas.this.gameTicker == 560) {
                            GameCanvas.this.showTitle(1);
                            GameCanvas.this.drawText(-1, 25, "press 5\nto start game\n\nor star key\nto exit!");
                        } else if (GameCanvas.this.gameTicker == 620) {
                            GameCanvas.this.gameTicker = 0;
                        }
                        if (GameCanvas.this.keyFire) {
                            GameCanvas.this.setGameState(1);
                        }
                        if (GameCanvas.this.keyLast != 42) break;
                        GameCanvas.this.setGameState(13);
                        break;
                    }
                    case 11: {
                        if (GameCanvas.this.gameTicker++ == 0) {
                            GameCanvas.this.showTitle(3);
                            GameCanvas.this.drawText(-1, 12, "would you like to\nsynchronise your\nhigh scores with\nother players on\nthe internet?");
                            GameCanvas.this.drawText(20, 50, "yes");
                            GameCanvas.this.drawText(GameCanvas.this.width - 32, 50, "no");
                            GameCanvas.this.cursorOn = true;
                            GameCanvas.this.cursorX = GameCanvas.this.width - 23;
                            GameCanvas.this.cursorY = 50;
                            GameCanvas.this.clearKeys();
                        } else if (GameCanvas.this.keyLeft) {
                            GameCanvas.this.cursorX = 35;
                        } else if (GameCanvas.this.keyRight) {
                            GameCanvas.this.cursorX = GameCanvas.this.width - 23;
                        } else if (GameCanvas.this.keyFire) {
                            if (GameCanvas.this.cursorX == 35) {
                                GameCanvas.this.setGameState(12);
                            } else {
                                GameCanvas.this.setGameState(10);
                            }
                        }
                        GameCanvas.this.clearKeys();
                        break;
                    }
                    case 12: {
                        if (GameCanvas.this.gameTicker++ == 0) {
                            GameCanvas.this.showTitle(3);
                            GameCanvas.this.drawText(-1, 20, "please wait a\nmoment while i\ntransfer scores...");
                            break;
                        }
                        if (GameCanvas.this.gameTicker == 10) {
                            GameCanvas.this.scoreList.sync();
                            break;
                        }
                        if (GameCanvas.this.gameTicker <= 100) break;
                        if (!ScoreList.syncDone) break;
                        GameCanvas.this.setGameState(10);
                        break;
                    }
                    case 13: {
                        if (GameCanvas.this.gameTicker++ == 0) {
                            GameCanvas.this.clearKeys();
                            GameCanvas.this.setBanner(7);
                        }
                        if (GameCanvas.this.keyLast == 49) {
                            GameCanvas.this.clearBanner();
                            GameCanvas.this.setGameState(10);
                        }
                        if (GameCanvas.this.keyLast != 51) break;
                        GameCanvas.this.blokDown.exit();
                        break;
                    }
                    case 14: {
                        if (GameCanvas.this.gameTicker++ == 0) {
                            GameCanvas.this.clearKeys();
                            GameCanvas.this.clearBuffer();
                            GameCanvas.this.drawText(-1, 0, "wow, you did it!\n\nthere are no more\nlevels!! you have\nbeaten me!\namazing!!!\n\npress select to\ncontinue...");
                        }
                        if (!GameCanvas.this.keyFire) break;
                        GameCanvas.this.setGameState(5);
                        break;
                    }
                }
                GameCanvas.this.repaint();
                GameCanvas.this.time = System.currentTimeMillis() - GameCanvas.this.time;
                try {
                    if (GameCanvas.this.time >= 50L) continue;
                    Thread.sleep(50 - (int)GameCanvas.this.time);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            GameCanvas.this.blokDown.exit();
        }
    }
}

