/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.sound.Sound;
import com.nokia.mid.ui.FullCanvas;
import java.io.IOException;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameCanvas
extends FullCanvas {
    int scrollX;
    int scrollY;
    int maxX;
    int maxY;
    int deltaX;
    int deltaY;
    int width;
    int height;
    int bufferWidth;
    int bufferHeight;
    int powerPillTmr;
    int dots;
    int bonusTmr;
    int scoreBoardY;
    int bIx;
    int bIy;
    int bIr;
    int bIc;
    int bIw;
    int bItimer;
    int gcX;
    int gcY;
    int gcW;
    int gcH;
    boolean init;
    boolean noXscroll;
    boolean noYscroll;
    boolean powerPillFF;
    String initialMap = "44444444444444444444444444444444444111111111111441111111111114444441444414444414414444414444144444424444144444144144444144442444444144441444441441444441444414444441111111111111111111111111144444414444144144444444144144441444444144441441444444441441444414444441111114411114411114411111144444444444144444044044444144444444444444441444440440444441444444444444444414400000000004414444444444444444144044444444044144444444444444441440444444440441444444440000000010004444444400010000000044444444144044444444044144444444444444441440444444440441444444444444444414400000000004414444444444444444144044444444044144444444444444441440444444440441444444444441111111111114411111111111144444414444144444144144444144441444444144441444441441444441444414444442114411111111111111114411244444444144144144444444144144144444444441441441444444441441441444444441111114411114411114411111144444414444444444144144444444441444444144444444441441444444444414444441111111111111111111111111144444444444444444444444444444444444";
    int[] jM;
    int[] jMp;
    int[] workingMap;
    int[] logic = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 4, 8, 1, 2, 4, 8, 1, 2, 4, 8, 1, 2, 8, 4, 1, 4, 2, 8, 1, 4, 2, 8, 4, 1, 8, 2, 4, 1, 8, 2};
    int[] logicUse = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 0, 1, 2, 3, 4, 5, 1, 2, 3, 4, 0, 0, 2, 4, 1, 3, 5, 4, 0, 2, 4, 1, 3, 5, 2, 0, 0, 0, 5, 1, 5, 2, 5, 3, 0, 1, 2, 3, 5, 4, 3, 2, 0, 0, 1, 2, 3, 5, 4, 2, 0, 5, 2, 3, 4, 5, 1, 2, 0};
    int[] revTable = new int[]{0, 2, 1, 0, 8, 0, 0, 0, 4};
    int[] gFrameTable = new int[]{0, 2, 3, 0, 1, 0, 0, 0, 0};
    int[] dSpeed = new int[]{512, 428, 300, 256, 480, 512, 460, 500, 356, 500, 700, 580, 540, 456, 620, 700, 620, 570, 526, 680, 700, 680, 600, 560, 700, 740, 700, 640, 600, 720};
    int[] pPtmr = new int[]{340, 240, 180, 100, 60, 30};
    int dSpeedIX = 0;
    PmanN pman;
    Display display;
    Sound s1;
    Sound s2;
    Sound s3;
    Image gameArt;
    Image buffer;
    Image scoreBuffer;
    Image hiScoreBuffer;
    Font font = Font.getFont((int)32, (int)1, (int)8);
    Font mediumFont = Font.getFont((int)32, (int)1, (int)0);
    Font bigFont = Font.getFont((int)32, (int)1, (int)16);
    Graphics bG;
    Graphics sG;
    Graphics hsG;

    GameCanvas(Display display, PmanN pmanN) {
        this.pman = pmanN;
        this.display = display;
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.scrollY = 0;
        this.scrollX = 0;
        this.init = true;
        this.noYscroll = false;
        this.noXscroll = false;
        this.bonusTmr = 0;
        this.maxX = 110 - this.width;
        this.maxY = 122 - this.height;
        this.gcW = 110;
        this.gcH = 122;
        this.deltaX = this.width / 2 - 4;
        this.deltaY = this.height / 2 - 4;
        if (this.maxX <= 0) {
            this.noXscroll = true;
        }
        if (this.maxY <= 0) {
            this.noYscroll = true;
        }
        this.bufferWidth = this.width < 110 ? 110 : this.width;
        this.bufferHeight = this.height < 122 ? 122 : this.height;
        this.buffer = Image.createImage((int)this.bufferWidth, (int)this.bufferHeight);
        this.bG = this.buffer.getGraphics();
        this.scoreBuffer = Image.createImage((int)70, (int)30);
        this.sG = this.scoreBuffer.getGraphics();
        this.sG.setColor(68);
        this.sG.fillRect(0, 0, 70, 30);
        this.sG.setColor(0xFFFF00);
        this.sG.drawRect(0, 0, 69, 29);
        this.sG.drawRect(2, 2, 65, 25);
        this.sG.setColor(0xFFFFFF);
        this.sG.setFont(this.font);
        this.sG.drawString("Score", 35, 4, 17);
        this.sG.setFont(this.mediumFont);
        this.hiScoreBuffer = Image.createImage((int)90, (int)50);
        this.hsG = this.hiScoreBuffer.getGraphics();
        this.hsG.setColor(0);
        this.hsG.fillRect(0, 0, 90, 50);
        this.hsG.setColor(0xFFFF00);
        this.hsG.setFont(this.font);
        this.hsG.drawString("HIGH SCORE", 45, 0, 17);
        this.hsG.setColor(65535);
        this.hsG.drawString("LAST SCORE", 45, 25, 17);
        this.hsG.setFont(this.bigFont);
        this.scoreBoardY = -50;
        try {
            this.gameArt = Image.createImage((String)"/g.png");
        }
        catch (IOException iOException) {
            System.out.println("Unable to load image!!");
        }
        int n = this.initialMap.length();
        this.jM = new int[n];
        this.jMp = new int[n];
        this.workingMap = new int[n];
        int n2 = 34;
        while (n2 < n - 34) {
            this.jM[n2] = 0;
            int n3 = 0;
            if (this.initialMap.charAt(n2) < '4') {
                if (this.initialMap.charAt(n2 - 32) < '4') {
                    this.jM[n2] = 1;
                    ++n3;
                }
                if (this.initialMap.charAt(n2 + 32) < '4') {
                    int n4 = n2;
                    this.jM[n4] = this.jM[n4] | 2;
                    ++n3;
                }
                if (this.initialMap.charAt(n2 - 1) < '4') {
                    int n5 = n2;
                    this.jM[n5] = this.jM[n5] | 4;
                    ++n3;
                }
                if (this.initialMap.charAt(n2 + 1) < '4') {
                    int n6 = n2;
                    this.jM[n6] = this.jM[n6] | 8;
                    ++n3;
                }
                this.jMp[n2] = this.jM[n2];
                if (n3 < 2 || this.jM[n2] == 3 || this.jM[n2] == 12) {
                    this.jM[n2] = 0;
                }
            }
            ++n2;
        }
        this.s1 = new Sound(480, 10L);
        this.s2 = new Sound(440, 10L);
    }

    public void CLS() {
        this.bG.setClip(0, 0, this.bufferWidth + 1, this.bufferHeight + 1);
        this.bG.setColor(0);
        this.bG.fillRect(0, 0, this.bufferWidth, this.bufferHeight);
    }

    public void drawScore(int n) {
        this.scoreBoardY = n;
        this.sG.setColor(68);
        this.sG.fillRect(3, 13, 62, 14);
        this.sG.setColor(0xFFFFFF);
        this.sG.drawString(this.pman.score + "", 36, 15, 17);
    }

    public void drawHiScore() {
        this.hsG.setColor(0);
        this.hsG.fillRect(0, 10, 90, 15);
        this.hsG.fillRect(0, 37, 90, 15);
        this.hsG.setColor(0xFFFFFF);
        this.hsG.drawString(this.pman.hiScore + "", 45, 9, 17);
        this.hsG.drawString(this.pman.score + "", 45, 34, 17);
    }

    public void setBonusOb(int n, int n2, int n3) {
        this.bIw = n == 1 ? 67 : 23;
        this.bIx = (this.pman.pacman.x >> 8) - (this.bIw >> 1) + 4;
        if (this.bIx < 0) {
            this.bIx = 0;
        }
        if (this.bIx + this.bIw > 110) {
            this.bIx = 110 - this.bIw;
        }
        this.bIy = this.pman.pacman.y >> 8;
        this.bIc = n == 1 ? 134 : 110;
        this.bIr = n2 << 3;
        this.bItimer = n3;
        ++this.bIw;
    }

    public void setBonusOb(int n, int n2, int n3, int n4, int n5) {
        this.bIw = n == 1 ? 67 : 23;
        this.bIx = n4 - (this.bIw >> 1) + 4;
        if (this.bIx < 0) {
            this.bIx = 0;
        }
        this.bIy = n5;
        this.bIc = n == 1 ? 133 : 110;
        this.bIr = n2 << 3;
        this.bItimer = n3;
        ++this.bIw;
    }

    public void setScroll(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n >= this.maxX) {
            n = this.maxX;
        }
        if (n2 >= this.maxY) {
            n2 = this.maxY;
        }
        if (!this.noXscroll) {
            this.scrollX = n;
        }
        if (!this.noYscroll) {
            this.scrollY = n2;
        }
        Sprite.xOffset = -this.scrollX + 1;
        Sprite.yOffset = -this.scrollY + 1;
    }

    public void newLevel() {
        this.init = true;
        this.dots = 242;
        int n = 0;
        while (n < this.workingMap.length) {
            this.workingMap[n] = this.initialMap.charAt(n) - 48;
            ++n;
        }
        this.bG.drawImage(this.gameArt, 0, -32, 20);
        this.restartLevel();
        System.gc();
    }

    public void restartLevel() {
        this.powerPillTmr = 0;
        this.bonusTmr = 0;
        this.dSpeedIX = (this.pman.level < 6 ? this.pman.level : 5) * 5;
        this.scrollX = -(this.width - 110) / 2;
        this.scrollY = -(this.height - 122) / 2;
        Sprite.xOffset = -this.scrollX + 1;
        Sprite.yOffset = -this.scrollY + 1;
        this.gcX = 0;
        this.gcY = 0;
        if (this.noXscroll) {
            this.gcX = this.scrollX;
        }
        if (this.noYscroll) {
            this.gcY = this.scrollY;
        }
        this.resetSprites();
    }

    public void resetSprites() {
        int[] nArray = new int[]{1, 0, 52, 88, 1, 1, 6, 50, 40, 1, 2, 7, 42, 53, 150, 3, 8, 50, 53, 80, 2, 9, 58, 53, 200};
        int n = 0;
        while (n < 8) {
            this.pman.sprite[n].reset();
            ++n;
        }
        n = 0;
        while (n < nArray.length) {
            this.pman.sprite[n / 5].setFrame(nArray[n], nArray[n + 1]);
            this.pman.sprite[n / 5].moveTo(nArray[n + 2], nArray[n + 3]);
            this.pman.sprite[n / 5].countDown = nArray[n + 4];
            this.pman.sprite[n / 5].on = true;
            this.pman.sprite[n / 5].setSpeed(1);
            n += 5;
        }
        this.pman.pacman.setAnimation(1, 5, true);
        this.pman.pacman.setDirection(-this.dSpeed[this.dSpeedIX], 0);
        this.pman.pacman.lastDir = 4;
        this.pman.pacman.nextDir = -1;
        this.pman.sprite[1].lastDir = 4;
        this.pman.sprite[1].setDirection(-256, 0);
        this.pman.sprite[2].state = 3;
        this.pman.sprite[2].setDirection(0, 256);
        this.pman.sprite[3].state = 3;
        this.pman.sprite[3].setDirection(0, -256);
        this.pman.sprite[4].state = 3;
        this.pman.sprite[4].setDirection(0, 256);
        this.pman.bonusSprite.setDirection(0, 0);
        this.pman.bonusSprite.setFrame(this.pman.level < 4 ? this.pman.level : 3, 12);
        this.pman.bonusSprite.moveTo(52, 64);
        this.pman.bonusSprite.state = 9;
        this.pman.bonusSprite.on = false;
    }

    protected void paint(Graphics graphics) {
        int n;
        this.setScroll((this.pman.pacman.x >> 8) - this.deltaX, (this.pman.pacman.y >> 8) - this.deltaY);
        if (this.init) {
            graphics.setClip(0, 0, this.bufferWidth + 1, this.bufferHeight + 1);
            graphics.setColor(0);
            graphics.fillRect(0, 0, this.bufferWidth, this.bufferHeight);
            this.init = false;
            return;
        }
        graphics.drawImage(this.buffer, -this.scrollX, -this.scrollY, 20);
        if (this.bItimer > 0) {
            --this.bItimer;
            graphics.setClip(this.bIx + Sprite.xOffset, this.bIy + Sprite.yOffset, this.bIw, 9);
            graphics.drawImage(this.gameArt, Sprite.xOffset + this.bIx - this.bIc, Sprite.yOffset + this.bIy - this.bIr, 20);
            if (this.pman.gameState == 1) {
                return;
            }
        }
        switch (this.pman.gameState) {
            case 1: {
                if (this.pman.pacman.x >> 8 < -4) {
                    this.pman.pacman.x += 27648;
                } else if (this.pman.pacman.x >> 8 > 106) {
                    this.pman.pacman.x -= 27648;
                }
                this.pman.pacman.checkHit();
                n = 0;
                while (n < 5) {
                    Sprite sprite = this.pman.sprite[n];
                    if (sprite.on) {
                        if (sprite.state < 3) {
                            this.checkMap(sprite);
                        }
                        sprite.x += sprite.xSpeed;
                        sprite.y += sprite.ySpeed;
                        sprite.paint(graphics);
                        this.checkDirChange(sprite);
                        this.spriteStateLogic(sprite);
                    }
                    ++n;
                }
                if (this.pman.bonusSprite.on) {
                    this.pman.bonusSprite.paint(graphics);
                }
                graphics.setClip(this.gcX, this.gcY, this.gcW + 1, this.gcH + 1);
                break;
            }
            case 2: {
                this.pman.pacman.paint(graphics);
                graphics.setClip(this.gcX, this.gcY, this.gcW + 1, this.gcH + 1);
                graphics.drawImage(this.scoreBuffer, (this.width - 70) / 2, this.scoreBoardY, 20);
                break;
            }
            case 3: {
                n = 0;
                while (n < 5) {
                    this.pman.sprite[n].paint(graphics);
                    ++n;
                }
                graphics.setClip(this.gcX, this.gcY, this.gcW + 1, this.gcH + 1);
                break;
            }
            case 4: {
                n = 4;
                while (n > -1) {
                    if (this.pman.sprite[n].on) {
                        this.pman.sprite[n].paint(graphics);
                    }
                    --n;
                }
                graphics.setClip(this.gcX, this.gcY, this.gcW + 1, this.gcH + 1);
                if (this.scoreBoardY <= -50) break;
                graphics.drawImage(this.scoreBuffer, (this.width - 70) / 2, this.scoreBoardY, 20);
            }
        }
        if (this.bonusTmr > 0 && --this.bonusTmr == 0) {
            this.pman.bonusSprite.on = false;
        }
        if (this.powerPillTmr > 0) {
            if (this.powerPillTmr < 50 && this.powerPillTmr % 3 == 0) {
                boolean bl = this.powerPillFF = !this.powerPillFF;
            }
            if (--this.powerPillTmr == 0) {
                n = 1;
                while (n < 5) {
                    if (this.pman.sprite[n].state == 1) {
                        this.pman.sprite[n].state = 0;
                        this.pman.sprite[n].animPos = 5 + n;
                    }
                    ++n;
                }
            }
        }
    }

    public void spriteStateLogic(Sprite sprite) {
        if (sprite.x >> 8 < -4) {
            sprite.x += 27648;
        } else if (sprite.x >> 8 > 106) {
            sprite.x -= 27648;
        }
        if (sprite.state == 3) {
            sprite.moveTo(sprite.x >> 8, sprite.y + sprite.ySpeed >> 8);
            if (sprite.y > 14336 || sprite.y < 12800) {
                sprite.ySpeed = -sprite.ySpeed;
            }
            if (sprite.countDown == 0) {
                sprite.setDirection(0, 0);
                sprite.state = 4;
            } else {
                --sprite.countDown;
            }
        } else if (sprite.state == 4) {
            if (sprite.x >> 8 < 50) {
                sprite.x += 256;
            } else if (sprite.x >> 8 > 50) {
                sprite.x -= 256;
            } else if (sprite.y >> 8 > 40) {
                sprite.y -= 256;
            } else {
                sprite.state = 0;
                sprite.lastDir = 4;
                sprite.setDirection(-this.dSpeed[this.dSpeedIX + sprite.ix], 0);
                sprite.timeSinceChg = 4;
            }
        } else if (sprite.state == 2 && sprite.x >> 8 > 47 && sprite.x >> 8 < 53 && sprite.y >> 8 == 40) {
            sprite.moveTo(50, 40);
            sprite.setDirection(0, 0);
            sprite.state = 5;
        } else if (sprite.state == 5) {
            if (sprite.y >> 8 < 53) {
                sprite.y += 512;
            } else {
                sprite.animPos = 5 + sprite.ix;
                sprite.state = 4;
            }
        }
    }

    public void getNewGhostDir(Sprite sprite, int n) {
        sprite.timeSinceChg = 5 - (this.dSpeed[sprite.ix] >> 8) > 0 ? 5 - (this.dSpeed[sprite.ix] >> 8) : 1;
        sprite.nextDir = 99;
        if ((n -= this.revTable[sprite.lastDir]) == 1 || n == 2 || n == 4 || n == 8) {
            sprite.nextDir = n;
            return;
        }
        int n2 = 0;
        if (this.logicUse[(sprite.ix << 4) + sprite.logicIX] < 5) {
            n2 = 0;
            while (n2 < 4) {
                switch (this.logic[(sprite.ix << 3) + n2 + this.logicUse[(sprite.ix << 4) + sprite.logicIX]] + (sprite.state == 1 ? 10 : (sprite.state == 2 ? 20 : 0))) {
                    case 1: {
                        if ((n & 1) != 1 || this.pman.pacman.y >= sprite.y) break;
                        sprite.nextDir = 1;
                        break;
                    }
                    case 2: {
                        if ((n & 2) != 2 || this.pman.pacman.y <= sprite.y) break;
                        sprite.nextDir = 2;
                        break;
                    }
                    case 4: {
                        if ((n & 4) != 4 || this.pman.pacman.x >= sprite.x) break;
                        sprite.nextDir = 4;
                        break;
                    }
                    case 8: {
                        if ((n & 8) != 8 || this.pman.pacman.x <= sprite.x) break;
                        sprite.nextDir = 8;
                        break;
                    }
                    case 11: {
                        if ((n & 1) != 1 || this.pman.pacman.y <= sprite.y) break;
                        sprite.nextDir = 1;
                        break;
                    }
                    case 12: {
                        if ((n & 2) != 2 || this.pman.pacman.y >= sprite.y) break;
                        sprite.nextDir = 2;
                        break;
                    }
                    case 14: {
                        if ((n & 4) != 4 || this.pman.pacman.x <= sprite.x) break;
                        sprite.nextDir = 4;
                        break;
                    }
                    case 18: {
                        if ((n & 8) != 8 || this.pman.pacman.x >= sprite.x) break;
                        sprite.nextDir = 8;
                        break;
                    }
                    case 21: {
                        if ((n & 1) != 1 || sprite.y <= 10240) break;
                        sprite.nextDir = 1;
                        break;
                    }
                    case 22: {
                        if ((n & 2) != 2 || sprite.y >= 10240) break;
                        sprite.nextDir = 2;
                        break;
                    }
                    case 24: {
                        if ((n & 4) != 4 || sprite.x <= 12800) break;
                        sprite.nextDir = 4;
                        break;
                    }
                    case 28: {
                        if ((n & 8) != 8 || sprite.x >= 12800) break;
                        sprite.nextDir = 8;
                    }
                }
                if (sprite.nextDir != 99) {
                    return;
                }
                ++n2;
            }
            sprite.nextDir = (n & 0xC) > 0 && this.pman.pacman.y >> 8 != sprite.y >> 8 ? ((n & 4) > 0 ? 4 : 8) : ((n & 1) > 0 ? 1 : 2);
            return;
        }
        n2 = 0;
        while (n2 < 4) {
            int n3 = n & this.logic[16 + n2];
            if (n3 > 0) {
                sprite.nextDir = n3;
                break;
            }
            ++n2;
        }
        if (++sprite.logicIX == 15) {
            sprite.logicIX = 0;
        }
    }

    public void checkDirChange(Sprite sprite) {
        int n;
        int n2;
        int n3;
        block17: {
            int n4;
            block15: {
                block16: {
                    n3 = sprite.ix;
                    n4 = (sprite.x + 3072 >> 10) + (sprite.y + 1024 >> 10 << 5);
                    if (n3 <= 0) break block15;
                    n2 = this.jM[n4];
                    if (sprite.timeSinceChg != 0 || n2 <= 0 || sprite.state >= 3) break block16;
                    this.getNewGhostDir(sprite, n2);
                    break block17;
                }
                if (sprite.timeSinceChg <= 0) break block17;
                --sprite.timeSinceChg;
                break block17;
            }
            n2 = this.jMp[n4];
            if (this.workingMap[n4] == 1) {
                this.pman.score += 10;
                if (--this.dots == 0) {
                    this.pman.gameTicker = 0;
                    this.pman.gameState = 2;
                }
                if (this.dots == 180 || this.dots == 80) {
                    this.bonusTmr = 90;
                    this.pman.bonusSprite.on = true;
                }
                this.workingMap[n4] = 0;
                this.bG.setColor(0);
                this.bG.fillRect(4 + ((sprite.x & 0xFFFFFC00) >> 8), 4 + ((sprite.y & 0xFFFFFC00) >> 8), 1, 1);
            } else if (this.workingMap[n4] == 2) {
                this.powerPillTmr = this.pPtmr[this.pman.level < 6 ? this.pman.level : 5];
                this.powerPillFF = false;
                this.pman.nextBonus = 200;
                this.workingMap[n4] = 0;
                this.bG.setColor(0);
                this.bG.fillRect(3 + ((sprite.x & 0xFFFFFC00) >> 8), 3 + ((sprite.y & 0xFFFFFC00) >> 8), 3, 3);
                n = 1;
                while (n < 5) {
                    if (this.pman.sprite[n].state == 0) {
                        if (this.pman.sprite[n].lastDir > -1) {
                            this.pman.sprite[n].xSpeed = -this.pman.sprite[n].xSpeed;
                            this.pman.sprite[n].ySpeed = -this.pman.sprite[n].ySpeed;
                            this.pman.sprite[n].lastDir = this.revTable[this.pman.sprite[n].lastDir];
                        }
                        this.pman.sprite[n].state = 1;
                        this.pman.sprite[n].animPos = 10;
                    }
                    ++n;
                }
            }
        }
        n = sprite.state == 1 ? 300 : (sprite.state == 2 ? 768 : this.dSpeed[n3 + this.dSpeedIX]);
        switch (sprite.nextDir) {
            case 1: {
                if ((n2 & 1) != 1) break;
                sprite.setDirection(0, -n);
                sprite.frame = n3 == 0 ? 2 : this.gFrameTable[1];
                sprite.lastDir = sprite.nextDir;
                sprite.nextDir = -1;
                sprite.x &= 0xFFFFFC00;
                break;
            }
            case 2: {
                if ((n2 & 2) != 2) break;
                sprite.setDirection(0, n);
                sprite.frame = n3 == 0 ? 3 : this.gFrameTable[2];
                sprite.lastDir = sprite.nextDir;
                sprite.nextDir = -1;
                sprite.x &= 0xFFFFFC00;
                break;
            }
            case 4: {
                if ((n2 & 4) != 4) break;
                sprite.setDirection(-n, 0);
                sprite.frame = n3 == 0 ? 1 : this.gFrameTable[4];
                sprite.lastDir = sprite.nextDir;
                sprite.nextDir = -1;
                sprite.y &= 0xFFFFFC00;
                break;
            }
            case 8: {
                if ((n2 & 8) != 8) break;
                sprite.setDirection(n, 0);
                sprite.frame = n3 == 0 ? 0 : this.gFrameTable[8];
                sprite.lastDir = sprite.nextDir;
                sprite.nextDir = -1;
                sprite.y &= 0xFFFFFC00;
                break;
            }
            case 16: {
                sprite.setDirection(0, 0);
            }
        }
    }

    public void checkMap(Sprite sprite) {
        switch (sprite.lastDir) {
            case 4: {
                if (this.jMp[(sprite.x + sprite.xSpeed + 3072 >> 10) + (sprite.y + 1024 >> 10 << 5)] == 0) {
                    sprite.x &= 0xFFFFFC00;
                    sprite.xSpeed = 0;
                }
                return;
            }
            case 1: {
                if (this.jMp[(sprite.x + 3328 >> 10) + (sprite.y + sprite.ySpeed + 1024 >> 10 << 5)] == 0) {
                    sprite.y &= 0xFFFFFC00;
                    sprite.ySpeed = 0;
                }
                return;
            }
            case 8: {
                int n = (sprite.x >> 8) + 4 >> 2;
                int n2 = (sprite.y >> 8) + 5 >> 2;
                if (this.jMp[n + (n2 << 5) + 3] == 0) {
                    sprite.x &= 0xFFFFFC00;
                    sprite.xSpeed = 0;
                    return;
                }
                if (this.jMp[n + (n2 << 5) + 4] == 0 && 4 - (sprite.x & 0x300) < sprite.xSpeed) {
                    sprite.x += 1024;
                    sprite.x &= 0xFFFFFC00;
                    sprite.xSpeed = 0;
                }
                return;
            }
            case 2: {
                int n = (sprite.x >> 8) + 5 >> 2;
                int n3 = (sprite.y >> 8) + 4 >> 2;
                if (this.jMp[n + (n3 << 5) + 34] == 0) {
                    sprite.y &= 0xFFFFFC00;
                    sprite.ySpeed = 0;
                    return;
                }
                if (this.jMp[n + (n3 << 5) + 66] != 0 || 4 - (sprite.y & 0x300) >= sprite.ySpeed) break;
                sprite.y += 1024;
                sprite.y &= 0xFFFFFC00;
                sprite.ySpeed = 0;
            }
        }
    }

    public void keyPressed(int n) {
        switch (this.getGameAction(n)) {
            case 1: {
                this.pman.pacman.nextDir = 1;
                break;
            }
            case 6: {
                this.pman.pacman.nextDir = 2;
                break;
            }
            case 2: {
                this.pman.pacman.nextDir = 4;
                break;
            }
            case 5: {
                this.pman.pacman.nextDir = 8;
                break;
            }
            case 8: {
                this.pman.pacman.nextDir = 2;
                break;
            }
        }
        if (n == -6) {
            this.pman.exitPressed = true;
        }
        if (n == -7) {
            this.pman.optionPressed = true;
        }
    }
}

