/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public class Brick {
    private int x;
    private int y;
    private int width;
    private int height;
    private int hitsLeft;
    private boolean active;
    private Canvas display;
    public static final int NONE = 0;
    public static final int TOP_LEFT = 1;
    public static final int TOP = 2;
    public static final int TOP_RIGHT = 3;
    public static final int RIGHT = 4;
    public static final int BOTTOM_RIGHT = 5;
    public static final int BOTTOM = 6;
    public static final int BOTTOM_LEFT = 7;
    public static final int LEFT = 8;

    public Brick() {
    }

    public Brick(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.hitsLeft = 1;
        this.active = true;
    }

    public int checkCollision(Ball ball) {
        int n = ball.getX();
        int n2 = n + ball.getWidth();
        int n3 = ball.getY();
        int n4 = n3 + ball.getHeight();
        int n5 = this.x + this.width;
        int n6 = this.y + this.height;
        if (n >= this.x && n <= n5 || n2 >= this.x && n2 <= n5) {
            if (n3 >= this.y && n3 <= n6 || n4 >= this.y && n4 <= n6) {
                --this.hitsLeft;
                if (this.hitsLeft <= 0) {
                    this.active = false;
                }
                int n7 = n + ball.getWidth() / 2;
                int n8 = n3 + ball.getHeight() / 2;
                if (n7 <= this.x && n8 >= n6) {
                    return 7;
                }
                if (n8 >= n6 && n7 >= this.x && n7 <= n5) {
                    return 6;
                }
                if (n8 >= n6 && n7 >= n5) {
                    return 5;
                }
                if (n7 <= this.x && n8 >= this.y && n8 <= n6) {
                    return 8;
                }
                if (n7 >= n5 && n8 >= this.y && n8 <= n6) {
                    return 4;
                }
                if (n7 <= this.x && n8 <= this.y) {
                    return 1;
                }
                if (n8 <= this.y && n7 >= this.x && n7 <= n5) {
                    return 2;
                }
                if (n7 >= n5 && n8 <= this.y) {
                    return 3;
                }
                if (ball.getSpeedY() < 0) {
                    return 2;
                }
                return 6;
            }
            return 0;
        }
        return 0;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getHitsLeft() {
        return this.hitsLeft;
    }

    public boolean isActive() {
        return this.active;
    }

    public void paint(Graphics graphics) {
        if (this.active) {
            int n = this.hitsLeft * 64;
            if (n > 255) {
                n = 255;
            }
            graphics.setColor(255 - n, 255 - n, 255 - n);
            graphics.fillRect(this.x, this.y, this.width, this.height);
        }
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public void setHitsLeft(int n) {
        this.hitsLeft = n;
    }

    public void setLocation(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public void setDisplay(Canvas canvas) {
        this.display = canvas;
    }
}

