/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class BrickMID
extends MIDlet
implements CommandListener {
    private Display myDisplay;
    private InnerCanvas myCanvas = new InnerCanvas();
    private IntroScreen introScreen;
    private HelpScreen helpScreen;
    private boolean paused;
    private boolean gameOver;
    private boolean wellDone;
    private int balls;
    private int score;
    private int level;
    private int screenWidth;
    private int screenHeight;
    private static final int TOTAL_BALLS = 3;
    private static final int TOTAL_BRICKS = 60;
    private static final int BRICKS_PER_LINE = 10;
    private static final int SPEED_OFFSET = 3;
    private static int BALL_SIZE = 5;
    private static int BALL_SPEED = 1;
    private static int BAT_WIDTH = 40;
    private static int BAT_HEIGHT = 5;
    private static int BRICK_WIDTH = 10;
    private static int BRICK_HEIGHT = 5;
    private Bat myBat;
    private Ball myBall;
    private int bricksLeft;
    private Brick[] myBricks;

    public BrickMID() {
        this.myCanvas.initScreen();
        this.myCanvas.setCommandListener(this);
        this.screenWidth = this.myCanvas.getWidth();
        this.screenHeight = this.myCanvas.getHeight();
        this.initDimensions();
        this.introScreen = new IntroScreen("Intro");
        this.introScreen.initScreen();
        this.introScreen.setCommandListener(this);
        this.helpScreen = new HelpScreen("Help");
        this.helpScreen.initScreen();
        this.helpScreen.setCommandListener(this);
        this.myBat = new Bat();
        this.myBat.setSize(BAT_WIDTH, BAT_HEIGHT);
        this.myBat.setLocation(this.screenWidth / 2, this.screenHeight - 30);
        this.myBat.setScreenWidth(this.screenWidth);
        this.newBall();
        this.initBricks();
    }

    public void initBricks() {
        this.myBricks = new Brick[60];
        int n = 0;
        int n2 = 0;
        int n3 = 4;
        int n4 = 0;
        int n5 = 0;
        while (n5 < 60) {
            this.myBricks[n5] = new Brick(n, n2, BRICK_WIDTH, BRICK_HEIGHT);
            this.myBricks[n5].setHitsLeft(n3);
            n += BRICK_WIDTH + 1;
            if (++n4 >= 10) {
                n = 0;
                if (n3 > 1) {
                    --n3;
                }
                n2 += BRICK_HEIGHT + 1;
                n4 = 0;
            }
            ++n5;
        }
        this.bricksLeft = 60;
    }

    public void initDimensions() {
        BRICK_WIDTH = this.screenWidth / 10;
        BAT_HEIGHT = BRICK_HEIGHT = BRICK_WIDTH / 2;
        BAT_WIDTH = this.screenWidth / 4;
        BALL_SIZE = BRICK_HEIGHT;
    }

    public void newBall() {
        this.myBall = new Ball();
        this.myBall.setSize(BALL_SIZE, BALL_SIZE);
        this.myBall.setDisplay(this.myCanvas);
        this.myBall.setSpeedX(0);
        this.myBall.setSpeedY(0);
        this.myBall.setStuckToBat(true);
        this.myBall.setActive(true);
        this.myBall.moveWithBat(this.myBat);
        this.myCanvas.repaint();
    }

    public void endOfLevel() {
        this.newBall();
        this.initBricks();
        this.wellDone = true;
    }

    public void startApp() throws MIDletStateChangeException {
        this.myDisplay = Display.getDisplay((MIDlet)this);
        if (!this.paused) {
            this.myDisplay.setCurrent((Displayable)this.introScreen);
        } else {
            this.myDisplay.setCurrent((Displayable)this.myCanvas);
            this.paused = false;
            this.myCanvas.startGameLoop();
        }
    }

    public void pauseApp() {
        this.paused = true;
    }

    public void destroyApp(boolean bl) throws MIDletStateChangeException {
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.introScreen) {
            if (command.getCommandType() == 5) {
                this.myDisplay.setCurrent((Displayable)this.helpScreen);
            } else if (command.getCommandType() == 6) {
                try {
                    this.destroyApp(true);
                }
                catch (Exception exception) {
                    System.out.println("Error destroying application:" + exception.getMessage());
                }
            } else if (command.getCommandType() == 1 && command.getLabel().equals("Start")) {
                this.startGame();
            }
        } else if (displayable == this.helpScreen) {
            if (command.getCommandType() == 2) {
                this.myDisplay.setCurrent((Displayable)this.introScreen);
            }
        } else if (displayable == this.myCanvas) {
            if (command.getCommandType() == 2) {
                this.pauseApp();
                this.myDisplay.setCurrent((Displayable)this.introScreen);
            } else {
                if (command.getCommandType() == 6) {
                    this.pauseApp();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return;
                }
                if (command.getCommandType() == 1) {
                    this.paused = false;
                    this.myCanvas.startGameLoop();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return;
                }
            }
        }
    }

    private void startGame() {
        this.balls = 3;
        this.score = 0;
        this.gameOver = false;
        this.level = 1;
        this.initBricks();
        this.myBat.setSpeed(this.level + 3);
        this.myDisplay.setCurrent((Displayable)this.myCanvas);
        this.myCanvas.startGameLoop();
    }

    class InnerCanvas
    extends Canvas
    implements Runnable {
        private int topLine;
        private int bottomLine;
        private int width;
        private int height;
        private int gameOverX;
        private int pauseX;
        private int wellDoneX;
        private Thread thread;
        private boolean initialised;
        private Command pauseCommand;
        private Command resumeCommand;
        private Command backCommand;
        private Font font;

        InnerCanvas() {
        }

        public void paint(Graphics graphics) {
            if (!this.initialised) {
                this.width = this.getWidth();
                this.height = this.getHeight();
                this.topLine = graphics.getFont().getHeight() + 1;
                this.gameOverX = this.width / 2 - graphics.getFont().stringWidth("Game Over") / 2;
                this.pauseX = this.width / 2 - graphics.getFont().stringWidth("Paused") / 2;
                this.wellDoneX = this.width / 2 - graphics.getFont().stringWidth("Well Done!") / 2;
                this.bottomLine = this.height - graphics.getFont().getHeight() - 1;
                this.initialised = true;
                BrickMID.this.myBat.setLocation(BrickMID.this.myBat.getX(), this.bottomLine - BrickMID.this.myBat.getHeight() - 2);
                BrickMID.this.newBall();
            }
            graphics.setColor(255, 255, 255);
            graphics.fillRect(0, 0, this.width, this.height);
            graphics.setColor(0, 0, 0);
            InnerCanvas innerCanvas = this;
            synchronized (innerCanvas) {
                graphics.drawString("Score:" + BrickMID.this.score, 0, 0, 20);
                graphics.drawString("Balls:" + BrickMID.this.balls, this.width, 0, 24);
                graphics.drawLine(0, this.topLine, this.width, this.topLine);
                graphics.translate(0, this.topLine);
                graphics.drawLine(0, this.bottomLine, this.width, this.bottomLine);
                graphics.setColor(255, 0, 0);
                int n = 0;
                while (n < 60) {
                    BrickMID.this.myBricks[n].paint(graphics);
                    ++n;
                }
                BrickMID.this.myBall.paint(graphics);
                BrickMID.this.myBat.paint(graphics);
                if (BrickMID.this.paused) {
                    graphics.drawString("Paused", this.pauseX, this.height / 2, 0);
                }
                if (BrickMID.this.gameOver) {
                    graphics.drawString("Game Over", this.gameOverX, this.height / 2, 0);
                }
                if (BrickMID.this.wellDone) {
                    graphics.drawString("Well Done!", this.gameOverX, this.height / 2, 0);
                }
            }
        }

        public void initScreen() {
            this.pauseCommand = new Command("Pause", 6, 1);
            this.addCommand(this.pauseCommand);
            this.backCommand = new Command("Back", 2, 1);
            this.addCommand(this.backCommand);
            this.resumeCommand = new Command("Resume", 1, 1);
        }

        public void keyPressed(int n) {
            if (this.getGameAction(n) == 2) {
                BrickMID.this.myBat.moveLeft();
                if (BrickMID.this.myBall.getStuckToBat()) {
                    BrickMID.this.myBall.moveWithBat(BrickMID.this.myBat);
                }
            } else if (this.getGameAction(n) == 5) {
                BrickMID.this.myBat.moveRight();
                if (BrickMID.this.myBall.getStuckToBat()) {
                    BrickMID.this.myBall.moveWithBat(BrickMID.this.myBat);
                }
            } else if (this.getGameAction(n) == 8 && BrickMID.this.myBall.getStuckToBat()) {
                BrickMID.this.myBall.setStuckToBat(false);
                BrickMID.this.wellDone = false;
                BrickMID.this.myBall.setSpeedX(BrickMID.this.myBat.getSpeed());
                BrickMID.this.myBall.setSpeedY(-BrickMID.this.myBat.getSpeed());
            }
        }

        public void keyRepeated(int n) {
            this.keyPressed(n);
        }

        public void run() {
            long l = 10L;
            long l2 = 0L;
            while (!BrickMID.this.paused && !BrickMID.this.gameOver) {
                InnerCanvas innerCanvas = this;
                synchronized (innerCanvas) {
                    int n;
                    l2 = System.currentTimeMillis();
                    BrickMID.this.myBall.moveBall();
                    if (BrickMID.this.myBall.getActive()) {
                        n = 0;
                        while (n < 60) {
                            int n2;
                            if (BrickMID.this.myBricks[n].isActive() && (n2 = BrickMID.this.myBricks[n].checkCollision(BrickMID.this.myBall)) != 0) {
                                BrickMID.this.score++;
                                BrickMID.this.myBall.hitBrick(n2);
                                if (!BrickMID.this.myBricks[n].isActive()) {
                                    BrickMID.this.bricksLeft--;
                                    if (BrickMID.this.bricksLeft < 1) {
                                        BrickMID.this.endOfLevel();
                                    }
                                }
                            }
                            ++n;
                        }
                    } else {
                        BrickMID.this.balls--;
                        if (BrickMID.this.balls <= 0) {
                            BrickMID.this.gameOver = true;
                        } else {
                            BrickMID.this.newBall();
                        }
                    }
                    n = BrickMID.this.myBat.checkCollision(BrickMID.this.myBall);
                    BrickMID.this.myBat;
                    if (n != 0) {
                        BrickMID.this.myBall.hitBat(BrickMID.this.myBat, n);
                    }
                }
                this.repaint();
                InnerCanvas innerCanvas2 = this;
                synchronized (innerCanvas2) {
                    long l3 = System.currentTimeMillis();
                    if ((l2 -= l3 - 1000L / l) > 0L) {
                        try {
                            Thread.sleep(l2);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            this.thread = null;
            this.removeCommand(this.pauseCommand);
            this.addCommand(this.resumeCommand);
        }

        public void startGameLoop() {
            BrickMID.this.paused = false;
            this.thread = new Thread(this);
            this.thread.start();
            this.removeCommand(this.resumeCommand);
            this.addCommand(this.pauseCommand);
        }
    }
}

