/*
 * Decompiled with CFR 0.152.
 */
package game.freecell;

import game.freecell.GameCanvas;
import java.util.Random;
import javax.microedition.lcdui.Graphics;

public class GameBoard {
    private final int maxHeight;
    private byte[] temp = new byte[4];
    private byte[] suit = new byte[4];
    private byte[][] stack = new byte[8][20];
    public int game;
    public int moves;
    public boolean gameover;
    public boolean solved;
    private byte[] _temp = new byte[4];
    private byte[] _suit = new byte[4];
    private byte[][] _stack = new byte[8][20];
    private int _moves;
    private boolean undo;
    private int curX;
    private int curY;
    private int selX;
    private int selY;
    private static final byte CARDS = 52;
    private static final byte NO_CARD = -1;
    private static final byte DIAMONDS = 0;
    private static final byte LEAVES = 1;
    private static final byte HEARTS = 2;
    private static final byte SPADES = 3;
    private final Random random = new Random();
    private long pack = 0L;

    public GameBoard(GameCanvas gameCanvas) {
        this.maxHeight = gameCanvas.getHeight();
    }

    public void newGame() {
        this.random.setSeed(System.currentTimeMillis());
        do {
            this.game = this.random.nextInt() & Short.MAX_VALUE;
        } while (this.game < 1 || this.game > 32000);
        this.initialize();
    }

    public void initialize() {
        int n;
        this.pack = 0L;
        this.random.setSeed(this.game);
        int n2 = 0;
        while (n2 < 8) {
            n = 0;
            while (n < 20) {
                this.stack[n2][n] = n2 < 4 && n < 7 || n < 6 ? (int)this.getCard() : -1;
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n < 4) {
            this.temp[n] = -1;
            this.suit[n] = -1;
            ++n;
        }
        this.moves = -1;
        this.undo = false;
        this.solved = false;
        this.gameover = false;
        this.setCursor(0, 0);
        this.setSelect();
    }

    public void update(int n) {
        switch (n) {
            case 0: {
                if (this.undo) {
                    System.arraycopy(this._temp, 0, this.temp, 0, 4);
                    System.arraycopy(this._suit, 0, this.suit, 0, 4);
                    int n2 = 0;
                    while (n2 < 8) {
                        System.arraycopy(this._stack[n2], 0, this.stack[n2], 0, 20);
                        ++n2;
                    }
                    this.setSelect();
                    this.moves = this._moves;
                    this.undo = false;
                    this.solved = false;
                    this.gameover = false;
                }
                return;
            }
            case 1: {
                if (this.curY == 1 && GameBoard.isValidCard(GameBoard.getLastCard(this.stack[this.curX]))) {
                    int n3 = 0;
                    while (n3 < 4) {
                        if (!GameBoard.isValidCard(this.temp[n3])) {
                            this.moveCards(this.curX, 1, n3, 0);
                            break;
                        }
                        ++n3;
                    }
                }
                return;
            }
            case 3: {
                int n4 = 0;
                while (n4 < 4) {
                    byte by = this.suit[n4];
                    this.moveCards(this.curX, this.curY, n4 + 4, 0);
                    if (this.suit[n4] != by) break;
                    ++n4;
                }
                return;
            }
        }
        if (this.curX == this.selX && this.curY == this.selY) {
            this.setSelect();
            return;
        }
        if (this.isSelected()) {
            this.moveCards(this.selX, this.selY, this.curX, this.curY);
        } else if (this.curY == 0 && this.curX < 4 && GameBoard.isValidCard(this.temp[this.curX]) || this.curY == 1 && GameBoard.isValidCard(this.stack[this.curX][0])) {
            this.setSelect(this.curX, this.curY);
        }
    }

    public void draw(Graphics graphics) {
        int n;
        if (this.curY == 1 && (n = GameBoard.getNumberOfCards(this.stack[this.curX]) * 6 + 26) > this.maxHeight) {
            graphics.translate(0, this.maxHeight - n);
        }
        n = 0;
        while (n < 4) {
            GameBoard.drawCard(graphics, n * 12, 0, this.temp[n], false, this.isSelected(n, 0), true);
            ++n;
        }
        int n2 = 0;
        while (n2 < 4) {
            GameBoard.drawCard(graphics, n2 * 12 + 49, 0, this.suit[n2], false, this.isSelected(n2 + 4, 0), true);
            ++n2;
        }
        int n3 = 0;
        while (n3 < 8) {
            int n4 = 0;
            while (n4 == 0 || this.stack[n3][n4] != -1) {
                boolean bl = this.stack[n3][n4 + 1] == -1;
                GameBoard.drawCard(graphics, n3 * 12, n4 * 6 + 17, this.stack[n3][n4], !bl, bl && this.isSelected(n3, 1), false);
                ++n4;
            }
            ++n3;
        }
    }

    private void saveUndo() {
        System.arraycopy(this.temp, 0, this._temp, 0, 4);
        System.arraycopy(this.suit, 0, this._suit, 0, 4);
        int n = 0;
        while (n < 8) {
            System.arraycopy(this.stack[n], 0, this._stack[n], 0, 20);
            ++n;
        }
        this._moves = this.moves;
        this.undo = true;
    }

    private void moveCards(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        if (n2 == 0 && n < 4) {
            if (n4 == 0) {
                if (n3 < 4) {
                    if (!GameBoard.isValidCard(this.temp[n3])) {
                        this.saveUndo();
                        this.temp[n3] = this.temp[n];
                        this.temp[n] = -1;
                        this.setSelect();
                    }
                } else if (this.canMoveToSuit(this.temp[n], this.suit[n3 - 4])) {
                    this.saveUndo();
                    this.suit[n3 - 4] = this.temp[n];
                    this.temp[n] = -1;
                    this.setSelect();
                }
            } else if (this.canMoveToStack(this.temp[n], GameBoard.getLastCard(this.stack[n3]))) {
                this.saveUndo();
                this.stack[n3][GameBoard.getNumberOfCards((byte[])this.stack[n3])] = this.temp[n];
                this.temp[n] = -1;
                this.setSelect();
            }
        } else if (n2 == 1) {
            if (n4 == 0) {
                if (n3 < 4) {
                    if (!GameBoard.isValidCard(this.temp[n3])) {
                        this.saveUndo();
                        this.temp[n3] = GameBoard.getLastCard(this.stack[n]);
                        this.stack[n][GameBoard.getNumberOfCards((byte[])this.stack[n]) - 1] = -1;
                        this.setSelect();
                    }
                } else if (this.canMoveToSuit(GameBoard.getLastCard(this.stack[n]), this.suit[n3 - 4])) {
                    this.saveUndo();
                    this.suit[n3 - 4] = GameBoard.getLastCard(this.stack[n]);
                    this.stack[n][GameBoard.getNumberOfCards((byte[])this.stack[n]) - 1] = -1;
                    this.setSelect();
                }
            } else {
                n9 = 1;
                n8 = 0;
                while (n8 < 4) {
                    if (!GameBoard.isValidCard(this.temp[n8])) {
                        ++n9;
                    }
                    ++n8;
                }
                n7 = 0;
                while (n7 < 8) {
                    if (!GameBoard.isValidCard(this.stack[n7][0]) && n7 != n3) {
                        n9 *= 2;
                    }
                    ++n7;
                }
                n9 = GameBoard.getNumberOfCards(this.stack[n]) - n9;
                n6 = GameBoard.getNumberOfCards(this.stack[n]) - 1;
                while (true) {
                    if (n6 < 0 || !this.canMoveToStack(this.stack[n][n6 + 1], this.stack[n][n6])) {
                        if (GameBoard.isValidCard(GameBoard.getLastCard(this.stack[n3]))) {
                            return;
                        }
                        if (++n6 >= n9) break;
                        n6 = n9;
                        break;
                    }
                    if (this.canMoveToStack(this.stack[n][n6], GameBoard.getLastCard(this.stack[n3])) && GameBoard.isValidCard(this.stack[n3][0])) break;
                    --n6;
                }
                if (n6 >= n9) {
                    this.saveUndo();
                    n5 = n6;
                    while (GameBoard.isValidCard(this.stack[n][n5])) {
                        this.stack[n3][GameBoard.getNumberOfCards((byte[])this.stack[n3])] = this.stack[n][n5];
                        this.stack[n][n5] = -1;
                        ++n5;
                    }
                    this.setSelect();
                }
            }
        }
        do {
            n9 = 0;
            n8 = 0;
            while (n8 < 4) {
                n7 = 0;
                while (n7 < 4) {
                    if (this.canMoveToSuit(this.temp[n8], this.suit[n7]) && this.canDiscard(this.temp[n8])) {
                        this.suit[n7] = this.temp[n8];
                        this.temp[n8] = -1;
                        n9 = 1;
                        break;
                    }
                    ++n7;
                }
                ++n8;
            }
            n7 = 0;
            while (n7 < 8) {
                n6 = 0;
                while (n6 < 4) {
                    if (this.canMoveToSuit(GameBoard.getLastCard(this.stack[n7]), this.suit[n6]) && this.canDiscard(GameBoard.getLastCard(this.stack[n7]))) {
                        this.suit[n6] = GameBoard.getLastCard(this.stack[n7]);
                        this.stack[n7][GameBoard.getNumberOfCards((byte[])this.stack[n7]) - 1] = -1;
                        n9 = 1;
                        break;
                    }
                    ++n6;
                }
                ++n7;
            }
        } while (n9 != 0);
        if (GameBoard.getCardRank(this.suit[0]) == 13 && GameBoard.getCardRank(this.suit[1]) == 13 && GameBoard.getCardRank(this.suit[2]) == 13 && GameBoard.getCardRank(this.suit[3]) == 13) {
            this.solved = true;
        } else {
            int n10;
            this.moves = -1;
            n8 = 0;
            while (n8 < 4) {
                if (!GameBoard.isValidCard(this.temp[n8])) {
                    return;
                }
                ++n8;
            }
            n7 = 0;
            while (n7 < 8) {
                if (!GameBoard.isValidCard(GameBoard.getLastCard(this.stack[n7]))) {
                    return;
                }
                ++n7;
            }
            this.moves = 0;
            n6 = 0;
            while (n6 < 4) {
                n5 = 0;
                while (n5 < 4) {
                    if (this.canMoveToSuit(this.temp[n6], this.suit[n5])) {
                        ++this.moves;
                    }
                    ++n5;
                }
                ++n6;
            }
            n5 = 0;
            while (n5 < 8) {
                n10 = 0;
                while (n10 < 4) {
                    if (this.canMoveToSuit(GameBoard.getLastCard(this.stack[n5]), this.suit[n10]) || GameBoard.isValidCard(this.temp[n10]) && this.canMoveToStack(this.temp[n10], GameBoard.getLastCard(this.stack[n5]))) {
                        ++this.moves;
                    }
                    ++n10;
                }
                ++n5;
            }
            n10 = 0;
            while (n10 < 8) {
                int n11 = 0;
                while (n11 < 8) {
                    if (this.canMoveToStack(GameBoard.getLastCard(this.stack[n10]), GameBoard.getLastCard(this.stack[n11]))) {
                        ++this.moves;
                    }
                    ++n11;
                }
                ++n10;
            }
            this.gameover = this.moves == 0;
        }
    }

    private boolean canDiscard(byte by) {
        if (!GameBoard.isValidCard(by)) {
            return false;
        }
        if (GameBoard.getCardRank(by) <= 2) {
            return true;
        }
        int n = 0;
        while (n < 4) {
            if (GameBoard.isValidCard(this.temp[n]) && this.canMoveToStack(this.temp[n], by)) {
                return false;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < 8) {
            int n3 = 0;
            while (GameBoard.isValidCard(this.stack[n2][n3])) {
                if (this.canMoveToStack(this.stack[n2][n3], by)) {
                    return false;
                }
                ++n3;
            }
            ++n2;
        }
        return true;
    }

    private boolean canMoveToStack(byte by, byte by2) {
        return !GameBoard.isValidCard(by) || !GameBoard.isValidCard(by2) || GameBoard.isValidCard(by2) && GameBoard.getCardSuit(by) % 2 != GameBoard.getCardSuit(by2) % 2 && GameBoard.getCardRank(by) + 1 == GameBoard.getCardRank(by2);
    }

    private boolean canMoveToSuit(byte by, byte by2) {
        return GameBoard.isValidCard(by) && (GameBoard.isValidCard(by2) && GameBoard.getCardSuit(by) == GameBoard.getCardSuit(by2) && GameBoard.getCardRank(by) - 1 == GameBoard.getCardRank(by2) || !GameBoard.isValidCard(by2) && GameBoard.getCardRank(by) == 1);
    }

    private void setCursor(int n, int n2) {
        this.curX = n;
        this.curY = n2;
    }

    public void moveCursor(int n, int n2) {
        if (this.curX + n >= 0 && this.curX + n <= 7 && this.curY + n2 >= 0 && this.curY + n2 <= 1) {
            this.setCursor(this.curX + n, this.curY + n2);
        }
    }

    private void setSelect() {
        this.selX = -1;
        this.selY = -1;
    }

    private void setSelect(int n, int n2) {
        this.selX = n;
        this.selY = n2;
    }

    private boolean isSelected() {
        return this.selX != -1 && this.selY != -1;
    }

    private boolean isSelected(int n, int n2) {
        return !this.solved && !this.gameover && (n == this.curX && n2 == this.curY || n == this.selX && n2 == this.selY);
    }

    private byte getCard() {
        int n;
        while ((n = this.random.nextInt() & 0x3F) >= 52 || (this.pack & 1L << n) != 0L) {
        }
        this.pack |= 1L << n;
        return (byte)n;
    }

    private static boolean isValidCard(byte by) {
        return by >= 0 && by < 52;
    }

    private static int getCardRank(byte by) {
        return by % 13 + 1;
    }

    private static int getCardSuit(byte by) {
        return by / 13;
    }

    private static byte getLastCard(byte[] byArray) {
        int n = GameBoard.getNumberOfCards(byArray);
        return n == 0 ? (byte)-1 : byArray[n - 1];
    }

    private static int getNumberOfCards(byte[] byArray) {
        int n = 0;
        while (byArray[n] != -1) {
            ++n;
        }
        return n;
    }

    private static void drawCard(Graphics graphics, int n, int n2, byte by, boolean bl, boolean bl2, boolean bl3) {
        graphics.translate(n, n2);
        graphics.setColor(0);
        if (bl2) {
            graphics.fillRect(0, 0, 11, 15);
            graphics.setColor(0xFFFFFF);
        } else if (bl3 || GameBoard.isValidCard(by)) {
            if (bl) {
                graphics.drawRect(0, 0, 10, 6);
            } else {
                graphics.drawRect(0, 0, 10, 14);
            }
        }
        if (GameBoard.isValidCard(by)) {
            switch (GameBoard.getCardSuit(by)) {
                case 0: {
                    graphics.drawLine(3, 2, 3, 4);
                    graphics.drawLine(2, 3, 4, 3);
                    if (bl) break;
                    graphics.drawLine(3, 10, 7, 10);
                    graphics.drawLine(5, 8, 5, 12);
                    graphics.drawRect(4, 9, 2, 2);
                    break;
                }
                case 2: {
                    graphics.drawLine(2, 2, 2, 3);
                    graphics.drawLine(3, 3, 3, 4);
                    graphics.drawLine(4, 2, 4, 3);
                    if (bl) break;
                    graphics.drawLine(5, 9, 5, 12);
                    graphics.drawLine(4, 11, 6, 11);
                    graphics.drawRect(3, 8, 1, 2);
                    graphics.drawRect(6, 8, 1, 2);
                    break;
                }
                case 1: {
                    graphics.drawLine(2, 2, 3, 3);
                    graphics.drawLine(2, 4, 4, 2);
                    if (bl) break;
                    graphics.drawLine(5, 10, 7, 12);
                    graphics.drawRect(3, 8, 1, 1);
                    graphics.drawRect(6, 8, 1, 1);
                    graphics.drawRect(3, 11, 1, 1);
                    break;
                }
                case 3: {
                    graphics.drawLine(2, 3, 2, 4);
                    graphics.drawLine(3, 2, 3, 3);
                    graphics.drawLine(4, 3, 4, 4);
                    if (bl) break;
                    graphics.drawLine(3, 10, 5, 8);
                    graphics.drawLine(7, 10, 5, 8);
                    graphics.drawLine(3, 11, 7, 11);
                    graphics.drawLine(5, 12, 5, 12);
                }
            }
            switch (GameBoard.getCardRank(by)) {
                case 1: {
                    graphics.drawLine(6, 3, 6, 6);
                    graphics.drawLine(7, 2, 7, 2);
                    graphics.drawLine(7, 4, 7, 4);
                    graphics.drawLine(8, 3, 8, 6);
                    break;
                }
                case 2: {
                    graphics.drawLine(6, 2, 8, 2);
                    graphics.drawLine(8, 3, 8, 3);
                    graphics.drawLine(6, 4, 8, 4);
                    graphics.drawLine(6, 5, 6, 5);
                    graphics.drawLine(6, 6, 8, 6);
                    break;
                }
                case 3: {
                    graphics.drawLine(6, 2, 7, 2);
                    graphics.drawLine(7, 4, 7, 4);
                    graphics.drawLine(6, 6, 7, 6);
                    graphics.drawLine(8, 2, 8, 6);
                    break;
                }
                case 4: {
                    graphics.drawLine(6, 4, 8, 2);
                    graphics.drawLine(6, 5, 8, 5);
                    graphics.drawLine(8, 6, 8, 5);
                    break;
                }
                case 5: {
                    graphics.drawLine(6, 2, 8, 2);
                    graphics.drawLine(6, 3, 6, 3);
                    graphics.drawLine(6, 4, 8, 4);
                    graphics.drawLine(8, 5, 8, 5);
                    graphics.drawLine(6, 6, 8, 6);
                    break;
                }
                case 6: {
                    graphics.drawLine(6, 3, 6, 3);
                    graphics.drawLine(6, 2, 8, 2);
                    graphics.drawRect(6, 4, 2, 2);
                    break;
                }
                case 7: {
                    graphics.drawLine(6, 2, 8, 2);
                    graphics.drawLine(7, 4, 8, 3);
                    graphics.drawLine(6, 5, 6, 6);
                    break;
                }
                case 8: {
                    graphics.drawRect(6, 2, 2, 4);
                    graphics.drawLine(7, 4, 7, 4);
                    break;
                }
                case 9: {
                    graphics.drawRect(6, 2, 2, 2);
                    graphics.drawLine(8, 5, 8, 5);
                    graphics.drawLine(6, 6, 8, 6);
                    break;
                }
                case 10: {
                    graphics.drawLine(6, 2, 6, 3);
                    graphics.drawLine(6, 5, 6, 6);
                    graphics.drawLine(7, 4, 7, 4);
                    graphics.drawLine(8, 2, 8, 3);
                    graphics.drawLine(8, 5, 8, 6);
                    break;
                }
                case 11: {
                    graphics.drawLine(6, 2, 8, 2);
                    graphics.drawLine(8, 3, 8, 5);
                    graphics.drawLine(6, 6, 7, 6);
                    break;
                }
                case 12: {
                    graphics.drawRect(6, 2, 2, 3);
                    graphics.drawLine(8, 6, 8, 6);
                    break;
                }
                case 13: {
                    graphics.drawLine(6, 2, 6, 6);
                    graphics.drawLine(7, 4, 7, 4);
                    graphics.drawLine(8, 2, 8, 3);
                    graphics.drawLine(8, 5, 8, 6);
                }
            }
        }
        graphics.translate(-n, -n2);
    }
}

