/*
 * Decompiled with CFR 0.152.
 */
package game.freecell;

import com.nokia.mid.ui.FullCanvas;
import game.freecell.FreeCell;
import game.freecell.GameBoard;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class GameCanvas
extends FullCanvas
implements CommandListener {
    private Display display;
    private FreeCell midlet;
    private GameBoard board;
    private List menu0;
    private List menu1;
    private Form menu2;
    private Form menu3;
    private TextBox menu4;
    private Command BACK_COMMAND = new Command("Back", 2, 1);
    private Command OK_COMMAND = new Command("OK", 4, 2);
    private Font font = Font.getFont((int)0, (int)0, (int)8);
    private RecordStore store;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GameCanvas(FreeCell freeCell) {
        this.midlet = freeCell;
        this.display = Display.getDisplay((MIDlet)this.midlet);
        this.board = new GameBoard(this);
        try {
            this.store = RecordStore.openRecordStore((String)"FreeCellGame", (boolean)true);
            byte[] byArray = new byte[2];
            byArray = this.store.getRecord(1);
            this.board.game = byArray[0] < 0 ? byArray[0] & 0x7F | 0x80 : byArray[0];
            this.board.game |= byArray[1] << 8;
        }
        catch (RecordStoreException recordStoreException) {
            this.board.newGame();
        }
        finally {
            this.board.initialize();
        }
    }

    public void destroy() {
        try {
            byte[] byArray = new byte[]{(byte)(this.board.game & 0xFF), (byte)(this.board.game >> 8)};
            if (this.store.getNumRecords() == 0) {
                this.store.addRecord(byArray, 0, 2);
            } else {
                this.store.setRecord(1, byArray, 0, 2);
            }
            this.store.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    protected void paint(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, this.getWidth() + 1, this.getHeight() + 1);
        this.board.draw(graphics);
        if (this.board.solved) {
            this.message(graphics, "CONGRATULATIONS", "You win!", AlertType.INFO);
        } else if (this.board.gameover) {
            this.message(graphics, "GAME OVER", "No more legal moves", AlertType.ERROR);
        }
    }

    private void message(Graphics graphics, String string, String string2, AlertType alertType) {
        graphics.translate(-graphics.getTranslateX(), -graphics.getTranslateY());
        graphics.setColor(0);
        graphics.fillRect(0, this.getHeight() / 2 - this.font.getHeight() - 3, this.getWidth(), this.font.getHeight() * 2 + 5);
        graphics.setColor(0xFFFFFF);
        graphics.setFont(this.font);
        graphics.drawString(string, this.getWidth() / 2, this.getHeight() / 2 - this.font.getHeight(), 0x10 | 1);
        graphics.drawString(string2, this.getWidth() / 2, this.getHeight() / 2, 0x10 | 1);
        alertType.playSound(this.display);
    }

    protected void keyPressed(int n) {
        if (this.board.solved || this.board.gameover) {
            if (n == -6 || n == -7) {
                this.display.setCurrent((Displayable)this.menu(0));
            } else if (n == 42) {
                this.board.update(0);
                this.repaint();
            }
            return;
        }
        switch (n) {
            case -7: 
            case -6: {
                this.display.setCurrent((Displayable)this.menu(0));
                return;
            }
            case 49: {
                this.board.update(1);
                this.repaint();
                return;
            }
            case 51: {
                this.board.update(3);
                this.repaint();
                return;
            }
            case 42: {
                this.board.update(0);
                this.repaint();
                return;
            }
        }
        switch (this.getGameAction(n)) {
            case 1: {
                this.board.moveCursor(0, -1);
                this.repaint();
                break;
            }
            case 6: {
                this.board.moveCursor(0, 1);
                this.repaint();
                break;
            }
            case 2: {
                this.board.moveCursor(-1, 0);
                this.repaint();
                break;
            }
            case 5: {
                this.board.moveCursor(1, 0);
                this.repaint();
                break;
            }
            case 8: {
                this.board.update(-1);
                this.repaint();
            }
        }
    }

    protected void keyRepeated(int n) {
        this.keyPressed(n);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.menu0) {
            if (command == this.BACK_COMMAND) {
                this.display.setCurrent((Displayable)this);
            } else if (command == List.SELECT_COMMAND) {
                switch (this.menu0.getSelectedIndex()) {
                    case 0: {
                        this.display.setCurrent((Displayable)this.menu(1));
                        break;
                    }
                    case 1: {
                        this.display.setCurrent((Displayable)this.menu(2));
                        break;
                    }
                    case 2: {
                        this.display.setCurrent((Displayable)this.menu(3));
                        break;
                    }
                    case 3: {
                        this.midlet.destroyApp(false);
                    }
                }
            }
        } else if (displayable == this.menu1) {
            if (command == this.BACK_COMMAND) {
                this.display.setCurrent((Displayable)this.menu0);
            } else if (command == List.SELECT_COMMAND) {
                switch (this.menu1.getSelectedIndex()) {
                    case 0: {
                        this.board.initialize();
                        this.display.setCurrent((Displayable)this);
                        break;
                    }
                    case 1: {
                        this.board.newGame();
                        this.display.setCurrent((Displayable)this);
                        break;
                    }
                    case 2: {
                        this.display.setCurrent((Displayable)this.menu(4));
                    }
                }
            }
        } else if (displayable == this.menu2 || displayable == this.menu3) {
            if (command == this.BACK_COMMAND) {
                this.display.setCurrent((Displayable)this.menu0);
            }
        } else if (displayable == this.menu4) {
            if (command == this.BACK_COMMAND) {
                this.display.setCurrent((Displayable)this.menu1);
            } else if (command == this.OK_COMMAND) {
                int n;
                try {
                    n = Integer.parseInt(this.menu4.getString());
                }
                catch (NumberFormatException numberFormatException) {
                    n = 0;
                }
                if (n < 1 || n > 32000) {
                    this.display.setCurrent(new Alert("Invalid input", "Game number must be from 1 to 32000", null, AlertType.ERROR), (Displayable)this.menu4);
                    return;
                }
                this.board.game = n;
                this.board.initialize();
                this.display.setCurrent((Displayable)this);
            }
        }
    }

    private Screen menu(int n) {
        Form form = null;
        switch (n) {
            case 0: {
                String[] stringArray = new String[]{"Game #" + this.board.game, "Help", "About", "Exit"};
                if (this.board.moves >= 0) {
                    stringArray[0] = stringArray[0] + "\n(Moves Left: " + this.board.moves + ")";
                }
                this.menu0 = new List("FreeCell", 3, stringArray, null);
                form = this.menu0;
                break;
            }
            case 1: {
                String[] stringArray = new String[]{"Restart Game", "New Game", "Select Game"};
                this.menu1 = new List("Game #" + this.board.game, 3, stringArray, null);
                form = this.menu1;
                break;
            }
            case 2: {
                form = this.menu2 = new Form("Help");
                this.menu2.append("The object of the game is to move all the cards to the home cells, using the free cells as placeholders. To win, you must make four stacks of cards on the home cells: one for each suit, with the ace on the bottom and each card stacked in order of rank.\n");
                this.menu2.append("- To move the cursor, press cursor keys or 2, 4, 6, 8.\n- To move a card, highlight it by pressing Fire or 5, then move the cursor where you want to move the card and press Fire or 5. You can also move a stack of cards from one column to another if there are enough free cells open. To cancel a move, press Fire or 5 on highlited card.\n- To quickly move a card to a free cell, press 1.\n- To quickly move a card to a home cell, press 3.\n- To undo the most recent move, press *.");
                break;
            }
            case 3: {
                form = this.menu3 = new Form("About");
                this.menu3.append("MIDP FreeCell\nversion 1.0\n\u00a9 2002 Petr Pa\u0159\u00edk");
                break;
            }
            case 4: {
                this.menu4 = new TextBox("Game Number:", String.valueOf(this.board.game), 5, 2);
                form = this.menu4;
            }
        }
        form.addCommand(this.BACK_COMMAND);
        form.setCommandListener((CommandListener)this);
        if (n == 4) {
            form.addCommand(this.OK_COMMAND);
        }
        return form;
    }
}

