/*
 * Decompiled with CFR 0.152.
 */
package sg.edu.ntu.eee.javajam;

import java.io.IOException;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextField;
import javax.microedition.lcdui.Ticker;
import javax.microedition.midlet.MIDlet;
import sg.edu.ntu.eee.javajam.About;
import sg.edu.ntu.eee.javajam.ConnectionWorker;
import sg.edu.ntu.eee.javajam.GadgetFactory;
import sg.edu.ntu.eee.javajam.GameCanvas;
import sg.edu.ntu.eee.javajam.GraphicsUtil;
import sg.edu.ntu.eee.javajam.Level;
import sg.edu.ntu.eee.javajam.Splash;
import sg.edu.ntu.eee.javajam.WaitCanvas;

public class J2MExed
extends MIDlet
implements CommandListener {
    private static J2MExed instance;
    private Display display;
    private TextField tb;
    private TextField license;
    private Form form;
    private byte currentForm;
    private Splash splash;
    private ImageItem logo;
    private boolean isSolution = false;
    private boolean finish = false;
    private boolean past5 = false;
    private Level level = new Level();
    private GameCanvas board;
    private List menu;
    private List skinList;
    private ConnectionWorker worker;
    private WaitCanvas waitCanvas;
    private Command okCommand;
    private Command cancelCommand;
    private Command undoCommand;
    private Command menuCommand;

    public J2MExed() {
        instance = this;
        try {
            this.jbInit();
        }
        catch (Exception exception) {}
    }

    public void startApp() {
        this.level.loadLatest();
        this.display.setCurrent((Displayable)this.splash);
        GadgetFactory.getPlayer().play(GadgetFactory.splashSound);
    }

    private void displayBoard() {
        if (this.isSolution) {
            this.board.removeCommand(this.undoCommand);
        } else {
            this.board.addCommand(this.undoCommand);
        }
        this.board.pause(false);
        this.display.setCurrent((Displayable)this.board);
    }

    public void highestLevelReached() {
        if (this.level.isRegistered()) {
            this.display.setCurrent(About.showAbout("Congratulation! You have completed all the levels.", AlertType.INFO), (Displayable)this.menu);
            this.finish = true;
        } else {
            this.display.setCurrent(About.showAbout("You need to register to play subsequent levels.", AlertType.ERROR), (Displayable)this.menu);
            this.past5 = true;
        }
    }

    public void pauseApp() {
        this.board.pause(true);
    }

    public void destroyApp(boolean bl) {
    }

    public static void quitApp() {
        instance.destroyApp(true);
        instance.notifyDestroyed();
        instance = null;
    }

    private void jbInit() throws Exception {
        this.display = Display.getDisplay((MIDlet)this);
        this.okCommand = new Command("OK", 4, 1);
        this.cancelCommand = new Command("Cancel", 3, 1);
        this.undoCommand = new Command("Undo", 2, 1);
        this.menuCommand = new Command("Menu", 1, 1);
        this.splash = new Splash();
        this.splash.setCommandListener(this);
        this.tb = new TextField("Enter level number", "", 2, 2);
        this.license = new TextField("Enter license key", "", 4, 0);
        this.form = new Form("");
        this.form.addCommand(this.okCommand);
        this.form.addCommand(this.cancelCommand);
        this.form.setCommandListener((CommandListener)this);
        this.board = GadgetFactory.getBoard(this);
        this.board.addCommand(this.menuCommand);
        this.board.setCommandListener(this);
        this.menu = new List("J2MExed - Menu", 3);
        this.menu.setCommandListener((CommandListener)this);
        this.menu.setTicker(new Ticker("Choose an option."));
        this.menu.append("Resume", Image.createImage((String)"/icons/undo.png"));
        this.menu.append("Show solution", Image.createImage((String)"/icons/solution.png"));
        this.menu.append("New game", Image.createImage((String)"/icons/new.png"));
        this.menu.append("Choose level", Image.createImage((String)"/icons/chooselevel.png"));
        this.menu.append("Change skin", Image.createImage((String)"/icons/changeskin.png"));
        this.menu.append("Register", Image.createImage((String)"/icons/download.png"));
        this.menu.append("Help", Image.createImage((String)"/icons/help.png"));
        this.menu.append("About", Image.createImage((String)"/icons/about.png"));
        this.menu.append("Exit", Image.createImage((String)"/icons/exit.png"));
    }

    public Level getLevel() {
        return this.level;
    }

    private void resetBoard() {
        this.board.reset();
        this.isSolution = false;
        this.displayBoard();
    }

    private void showSolution() {
        this.board.showSolution();
        this.isSolution = true;
        this.displayBoard();
    }

    public static String getProperty(String string) {
        return instance.getAppProperty(string);
    }

    private void emptyForm() {
        while (this.form.size() > 0) {
            this.form.delete(0);
        }
    }

    private void chooseLevel() {
        this.tb.setString("");
        this.emptyForm();
        this.form.setTitle("J2MExed - Choose level");
        this.form.addCommand(this.cancelCommand);
        this.form.append((Item)this.tb);
        this.display.setCurrent((Displayable)this.form);
        this.currentForm = 0;
    }

    private void showHelp() {
        this.emptyForm();
        this.form.removeCommand(this.cancelCommand);
        this.form.setTitle("J2MExed - Help");
        this.form.append("1. How to play\nYour goal is to move similar blocks together, which causes them to disappear. Once all the blocks are gone, you've solved the level and you're presented with a new level to solve.\nYou move a block by selecting it using the blinking cursor and dragging to either the right or left. If an empty space is encountered, \"gravity\" takes over and the blocks fall towards the bottom.\n\n2. License\nThe demo version only allows you to play first 5 levels. Once you buy a license key and register it, you can play all 20 levels.\n\n");
        this.display.setCurrent((Displayable)this.form);
        this.currentForm = (byte)2;
    }

    private void showAboutBox() {
        this.emptyForm();
        this.form.removeCommand(this.cancelCommand);
        this.form.setTitle("J2MExed - About");
        if (this.logo == null) {
            try {
                this.logo = new ImageItem("", Image.createImage((String)"/icons/splash.png"), 515, "logo");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.form.append((Item)this.logo);
        this.form.append("J2MExed was written as an entry to the Wireless Java Jam 2002 competition organised by JWCC, Singapore.\nDevelopers: Nguyen Thanh Nam & Nguyen Kinh Luan from NTU.\nCopyright (C) 2002. All rights reserved.");
        this.display.setCurrent((Displayable)this.form);
        this.currentForm = (byte)3;
    }

    private void changeSkin() {
        if (this.skinList == null) {
            this.skinList = new List("J2MExed - Choose a skin", 3);
            this.skinList.addCommand(this.okCommand);
            this.skinList.addCommand(this.cancelCommand);
            this.skinList.setCommandListener((CommandListener)this);
            try {
                this.skinList.append("Default", Image.createImage((String)"/blocks/default/block1.png"));
                this.skinList.append("Jewels", Image.createImage((String)"/blocks/jewels/block1.png"));
                this.skinList.append("Flags", Image.createImage((String)"/blocks/flags/block1.png"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.board.pause(true);
        this.display.setCurrent((Displayable)this.skinList);
    }

    private void registerLicense() {
        if (this.level.isRegistered()) {
            About.showAbout("You have already registered. Thank you.", AlertType.INFO, this.display);
        } else {
            this.license.setString("");
            this.emptyForm();
            this.form.setTitle("J2MExed - Register");
            this.form.addCommand(this.cancelCommand);
            this.form.append((Item)this.license);
            this.display.setCurrent((Displayable)this.form);
            this.currentForm = 1;
            if (this.waitCanvas == null) {
                this.waitCanvas = new WaitCanvas();
            }
        }
    }

    private void doConnection() {
        this.display.setCurrent((Displayable)this.waitCanvas);
        this.worker = new ConnectionWorker(this, this.waitCanvas, this.getAppProperty("license.url") + this.license.getString());
        this.worker.start();
    }

    public void networkResponse(byte by) {
        switch (by) {
            case 0: {
                this.waitCanvas = null;
                this.level.setRegistered();
                if (this.past5 && this.level.getId() == 5) {
                    this.level.setLastLevel(6);
                    this.level.loadLevel(6);
                }
                this.display.setCurrent(About.showAbout("You have been successfully registered. All levels are unlocked.", AlertType.INFO), (Displayable)this.menu);
                break;
            }
            case 1: {
                this.display.setCurrent(About.showAbout("Invalid key. Please try again", AlertType.ERROR), (Displayable)this.form);
                break;
            }
            case 2: {
                this.display.setCurrent(About.showAbout("Internet connection error.", AlertType.ERROR), (Displayable)this.form);
            }
        }
        this.worker = null;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.form && this.currentForm == 0) {
            if (command == this.okCommand && this.tb.getString().length() > 0) {
                int n = Integer.parseInt(this.tb.getString());
                if (n > 20) {
                    About.showAbout("Your level number exceeds the maximum value.", AlertType.ERROR, this.display);
                } else if (this.level.loadLevel(n)) {
                    this.resetBoard();
                } else {
                    About.showAbout("You have not reached this level yet.", AlertType.ERROR, this.display);
                }
            } else if (command == this.cancelCommand) {
                this.display.setCurrent((Displayable)this.menu);
            }
        } else if (displayable == this.form && this.currentForm == 1) {
            if (command == this.okCommand && this.license.getString().length() > 0) {
                this.doConnection();
            } else if (command == this.cancelCommand) {
                this.display.setCurrent((Displayable)this.menu);
            }
        } else if (displayable == this.form && this.currentForm > 1) {
            this.display.setCurrent((Displayable)this.menu);
        } else if (displayable == this.board) {
            if (command == this.menuCommand) {
                this.board.pause(true);
                this.display.setCurrent((Displayable)this.menu);
            } else if (command == this.undoCommand) {
                this.board.undoMove();
            }
        } else if (displayable == this.skinList) {
            if (command == this.okCommand || command == List.SELECT_COMMAND) {
                GraphicsUtil.setSkin(this.skinList.getString(this.skinList.getSelectedIndex()).toLowerCase());
                this.displayBoard();
            } else if (command == this.cancelCommand) {
                this.display.setCurrent((Displayable)this.menu);
            }
        } else if (displayable == this.splash) {
            this.splash = null;
            this.isSolution = false;
            this.displayBoard();
        } else if (displayable == this.menu && command == List.SELECT_COMMAND) {
            switch (this.menu.getSelectedIndex()) {
                case 0: {
                    this.displayBoard();
                    break;
                }
                case 1: {
                    this.showSolution();
                    break;
                }
                case 2: {
                    if (this.finish) {
                        this.level.loadLevel(1);
                        this.finish = false;
                    }
                    this.resetBoard();
                    break;
                }
                case 3: {
                    this.chooseLevel();
                    break;
                }
                case 4: {
                    this.changeSkin();
                    break;
                }
                case 5: {
                    this.registerLicense();
                    break;
                }
                case 6: {
                    this.showHelp();
                    break;
                }
                case 7: {
                    this.showAboutBox();
                    break;
                }
                case 8: {
                    J2MExed.quitApp();
                }
            }
        }
    }
}

