/*
 * Decompiled with CFR 0.152.
 */
package sg.edu.ntu.eee.javajam;

import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import sg.edu.ntu.eee.javajam.J2MExed;

public class Level {
    private int id = 1;
    private int lastLevel = 1;
    private boolean registered = false;
    private RecordStore rs;
    private static final int REGISTERED_FIELD = 1;
    private static final int LAST_LEVEL_FIELD = 0;
    public static final int HIGHEST_LEVEL_UNREGISTERED = 5;
    public static final int HIGHEST_LEVEL = 20;
    public static final int[][] map = new int[8][10];

    public Level() {
        try {
            this.rs = RecordStore.openRecordStore((String)"J2MExed", (boolean)true);
            RecordEnumeration recordEnumeration = this.rs.enumerateRecords(null, null, false);
            if (recordEnumeration.hasNextElement()) {
                byte[] byArray = recordEnumeration.nextRecord();
                this.lastLevel = byArray[0];
                this.registered = byArray[1] == 1;
                recordEnumeration.destroy();
            } else {
                byte[] byArray = new byte[]{1, 0};
                this.rs.addRecord(byArray, 0, 2);
            }
            this.rs.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lastLevel = !this.registered ? Math.min(this.lastLevel, 5) : Math.min(this.lastLevel, 20);
    }

    public boolean loadLevel(int n) {
        if (!this.registered && n > 5 || n > this.lastLevel) {
            return false;
        }
        this.parseLevel(J2MExed.getProperty("Level_" + n));
        this.id = n;
        return true;
    }

    public boolean loadLatest() {
        return this.loadLevel(this.lastLevel);
    }

    private void parseLevel(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer("");
        do {
            char c = string.charAt(n);
            ++n;
            if (c >= '0' && c <= '9') {
                stringBuffer.append(c);
                continue;
            }
            n3 += this.fillRock(n2, n3, stringBuffer);
            if (c >= 'a' && c <= 'z') {
                c = (char)(c - 97 + 1);
                Level.map[n2][n3++] = 256 * c;
                continue;
            }
            if (c == '~') {
                Level.map[n2][n3++] = 2304;
                continue;
            }
            if (c != '/') continue;
            ++n2;
            n3 = 0;
        } while (n < string.length());
    }

    public String getSolution() {
        return J2MExed.getProperty("Solution_" + this.id);
    }

    public int getSolutionSteps() {
        return this.getSolution().length() >> 1;
    }

    private int fillRock(int n, int n2, StringBuffer stringBuffer) {
        int n3 = 0;
        try {
            n3 = Integer.parseInt(stringBuffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            n3 = 0;
        }
        int n4 = 0;
        while (n4 < n3) {
            Level.map[n][n2++] = 0;
            ++n4;
        }
        stringBuffer.setLength(0);
        return n3;
    }

    public int getId() {
        return this.id;
    }

    public void setRegistered() {
        this.setField(1, (byte)1);
        this.registered = true;
    }

    public void setLastLevel(int n) {
        if (n > 20) {
            return;
        }
        if (n > this.lastLevel) {
            this.lastLevel = n;
            this.setField(0, (byte)n);
        }
    }

    private void setField(int n, byte by) {
        try {
            this.rs = RecordStore.openRecordStore((String)"J2MExed", (boolean)true);
            RecordEnumeration recordEnumeration = this.rs.enumerateRecords(null, null, false);
            byte[] byArray = recordEnumeration.nextRecord();
            byArray[n] = by;
            recordEnumeration.reset();
            this.rs.setRecord(recordEnumeration.nextRecordId(), byArray, 0, 2);
            recordEnumeration.destroy();
            this.rs.closeRecordStore();
        }
        catch (Exception exception) {}
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public boolean isHighestLevel() {
        if (this.registered) {
            return this.id >= 20;
        }
        return this.id >= 5;
    }

    public boolean loadNextLevel() {
        return this.loadLevel(this.id + 1);
    }
}

