/*
 * Decompiled with CFR 0.152.
 */
package sg.edu.ntu.eee.javajam;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import sg.edu.ntu.eee.javajam.Block;
import sg.edu.ntu.eee.javajam.GameCanvas;
import sg.edu.ntu.eee.javajam.GraphicsUtil;
import sg.edu.ntu.eee.javajam.J2MExed;
import sg.edu.ntu.eee.javajam.Level;

public class NormalBoard
extends GameCanvas
implements Runnable {
    private static int NORMAL = 0;
    private static int SHOW_SOLUTION = 1;
    private static int WON = 2;
    private static int DELAY = 200;
    private static final int[][] oldMap = new int[8][10];
    private static final int[][] curMap = new int[8][10];
    private J2MExed parent;
    private Image offscreen;
    private Graphics offGraphics;
    private Level level;
    private Thread me;
    private boolean firstTime = true;
    private boolean paused = true;
    private boolean showArrow = false;
    private int width;
    private int height;
    private int fontHeight;
    private int state;
    private int oldState;
    private int cursorX = 0;
    private int cursorY = 0;
    private int selectedX;
    private int selectedY;
    private int row;
    private int col;
    private int cursorState = 0;
    private int solutionStep;
    private int moves = 0;
    private int oldMoves = 0;
    private int translateX;
    private int translateY;
    private StringBuffer text = new StringBuffer(20);

    public NormalBoard() {
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.state = NORMAL;
        this.oldState = NORMAL;
        this.unSelect();
    }

    public NormalBoard(J2MExed j2MExed) {
        this();
        this.setParent(j2MExed);
    }

    public void setParent(J2MExed j2MExed) {
        this.parent = j2MExed;
        this.level = j2MExed.getLevel();
        this.me = new Thread(this);
        this.me.start();
    }

    private void updateLevel() {
        this.row = 0;
        while (this.row < 8) {
            System.arraycopy(Level.map[this.row], 0, curMap[this.row], 0, 10);
            System.arraycopy(curMap[this.row], 0, oldMap[this.row], 0, 10);
            ++this.row;
        }
    }

    protected void paint(Graphics graphics) {
        if (this.firstTime) {
            GraphicsUtil.init();
            this.offscreen = Image.createImage((int)this.width, (int)this.height);
            this.offGraphics = this.offscreen.getGraphics();
            this.offGraphics.setFont(Font.getFont((int)0, (int)0, (int)0));
            this.fontHeight = this.offGraphics.getFont().getHeight();
            this.translateX = (this.width - 140) / 2;
            this.translateY = (this.fontHeight + this.height - 112) / 2;
            this.offGraphics.translate(this.translateX, this.translateY);
            this.width = 140;
            this.height = 112;
            this.updateLevel();
            this.firstTime = false;
        }
        this.clearRect(this.offGraphics, -2, -2, this.width + 4, this.height + 4);
        this.clearRect(this.offGraphics, -this.translateX, -this.translateY, this.getWidth(), this.fontHeight);
        this.row = 0;
        while (this.row < 8) {
            this.col = 0;
            while (this.col < 10) {
                Block.setBlock(curMap[this.row][this.col]);
                Block.paint(this.offGraphics, this.col * 14, this.row * 14);
                ++this.col;
            }
            ++this.row;
        }
        if (this.state != SHOW_SOLUTION) {
            this.blinkCursor();
        }
        if (this.state != SHOW_SOLUTION) {
            this.text.setLength(0);
            this.text.append("Level ");
            this.text.append(this.level.getId());
            this.offGraphics.drawString(this.text.toString(), -this.translateX + 1, -this.translateY, 20);
            this.text.setLength(0);
            this.text.append(this.moves);
            this.text.append(" move(s)");
            this.offGraphics.drawString(this.text.toString(), this.getWidth() - this.translateX, -this.translateY, 24);
        } else {
            this.text.setLength(0);
            this.text.append("Level ");
            this.text.append(this.level.getId());
            this.text.append(" solution");
            this.offGraphics.drawString(this.text.toString(), -this.translateX + 1, -this.translateY, 20);
            this.text.setLength(0);
            this.text.append(this.moves);
            this.text.append('/');
            this.text.append(this.level.getSolutionSteps());
            this.text.append(" moves");
            this.offGraphics.drawString(this.text.toString(), this.getWidth() - this.translateX, -this.translateY, 24);
            if (this.showArrow) {
                this.drawArrow();
            }
        }
        graphics.drawImage(this.offscreen, 0, 0, 0);
    }

    private void drawArrow() {
        int n = this.selectNextCoordinate();
        if (n >= 2) {
            return;
        }
        int n2 = this.offGraphics.getColor();
        this.offGraphics.setColor(255, 128, 64);
        int n3 = this.selectedY * 14 + 7;
        if (n == 1) {
            int n4 = this.selectedX * 14 + 7;
            this.offGraphics.fillRect(n4, n3, 14, 2);
            this.offGraphics.drawLine(n4 += 14, n3, n4 - 3, n3 - 3);
            this.offGraphics.drawLine(n4 - 1, n3, n4 - 4, n3 - 3);
            this.offGraphics.drawLine(n4, ++n3, n4 - 3, n3 + 3);
            this.offGraphics.drawLine(n4 - 1, n3, n4 - 4, n3 + 3);
        } else {
            int n5 = (this.selectedX - 1) * 14 + 7;
            this.offGraphics.fillRect(n5, n3, 14, 2);
            this.offGraphics.drawLine(n5, n3, n5 + 3, n3 - 3);
            this.offGraphics.drawLine(n5 + 1, n3, n5 + 4, n3 - 3);
            this.offGraphics.drawLine(n5, ++n3, n5 + 3, n3 + 3);
            this.offGraphics.drawLine(n5 + 1, n3, n5 + 4, n3 + 3);
        }
        this.offGraphics.setColor(n2);
    }

    private int selectNextCoordinate() {
        char c;
        boolean bl = false;
        int n = this.solutionStep << 1;
        String string = this.level.getSolution();
        if (n >= string.length()) {
            return 2;
        }
        if ((c = string.charAt(n++)) >= 'a') {
            bl = true;
        }
        this.selectedX = bl ? c - 97 : c - 65;
        c = string.charAt(n);
        this.selectedY = c >= 'a' ? c - 97 : c - 65;
        if (bl) {
            return 1;
        }
        return 0;
    }

    private void clearRect(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = graphics.getColor();
        graphics.setColor(255, 255, 255);
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(n5);
    }

    protected void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        if (n == 54 || n2 == 5) {
            if (this.state == SHOW_SOLUTION) {
                if (this.selectNextCoordinate() == 1) {
                    this.nextSolutionStep();
                }
            } else {
                ++this.cursorX;
                if (this.cursorX > 9) {
                    this.cursorX = 9;
                }
                this.moveBlockRight();
            }
        } else if (n == 52 || n2 == 2) {
            if (this.state == SHOW_SOLUTION) {
                if (this.selectNextCoordinate() == 0) {
                    this.nextSolutionStep();
                }
            } else {
                --this.cursorX;
                if (this.cursorX < 0) {
                    this.cursorX = 0;
                }
                this.moveBlockLeft();
            }
        } else if (n == 50 || n2 == 1) {
            if (this.state == SHOW_SOLUTION) {
                return;
            }
            if (this.notSelected()) {
                --this.cursorY;
                if (this.cursorY < 0) {
                    this.cursorY = 0;
                }
            }
        } else if (n == 56 || n2 == 6) {
            if (this.state == SHOW_SOLUTION) {
                return;
            }
            if (this.notSelected()) {
                ++this.cursorY;
                if (this.cursorY > 7) {
                    this.cursorY = 7;
                }
            }
        } else if (n == 53 || n2 == 8) {
            if (this.state == SHOW_SOLUTION) {
                return;
            }
            if (this.notSelected() && curMap[this.cursorY][this.cursorX] < 2304 && curMap[this.cursorY][this.cursorX] >= 256) {
                this.selectedX = this.cursorX;
                this.selectedY = this.cursorY;
            } else {
                this.unSelect();
            }
        }
        this.update();
        this.processMap();
        if (this.state == SHOW_SOLUTION) {
            this.showArrow = true;
            this.update();
        }
    }

    private void unSelect() {
        this.selectedY = -1;
        this.selectedX = -1;
    }

    private boolean notSelected() {
        return this.selectedX < 0 || this.selectedY < 0;
    }

    private void processMap() {
        boolean bl;
        this.paused = true;
        while (bl = this.dropBlocks() || this.shrinkBlocks()) {
        }
        this.paused = false;
        if (!(this.notSelected() || curMap[this.selectedY][this.selectedX] >= 256 && curMap[this.selectedY][this.selectedX] < 2304)) {
            this.unSelect();
        }
        if (this.state == WON) {
            this.levelCleared();
        }
    }

    private void nextSolutionStep() {
        this.showArrow = false;
        int n = this.selectNextCoordinate();
        if (n >= 2) {
            return;
        }
        if (n == 1) {
            this.moveBlockRight();
        } else {
            this.moveBlockLeft();
        }
        ++this.solutionStep;
    }

    private boolean dropBlocks() {
        boolean bl;
        boolean bl2 = false;
        if (this.notSelected()) {
            return false;
        }
        do {
            bl = true;
            this.row = 7;
            while (this.row > 0) {
                this.col = 0;
                while (this.col < 10) {
                    if (curMap[this.row][this.col] >= 2304 && curMap[this.row - 1][this.col] >= 256 && curMap[this.row - 1][this.col] < 2304) {
                        NormalBoard.curMap[this.row][this.col] = curMap[this.row - 1][this.col];
                        NormalBoard.curMap[this.row - 1][this.col] = 2304;
                        bl = false;
                    }
                    ++this.col;
                }
                --this.row;
            }
            if (bl) continue;
            this.update();
            this.delay(DELAY);
            bl2 = true;
        } while (!bl);
        return bl2;
    }

    private boolean shrinkBlocks() {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.notSelected()) {
            return false;
        }
        do {
            int n = 0;
            bl = true;
            this.row = 0;
            while (this.row < 7) {
                this.col = 0;
                while (this.col < 9) {
                    if (Block.getFrame(curMap[this.row][this.col]) > 0) {
                        NormalBoard.curMap[this.row][this.col] = 2304;
                        bl = false;
                        bl3 = true;
                    } else if (curMap[this.row][this.col] >= 256 && curMap[this.row][this.col] < 2304) {
                        ++n;
                        if (curMap[this.row][this.col] == curMap[this.row][this.col + 1] && curMap[this.row][this.col] == curMap[this.row + 1][this.col + 1] && curMap[this.row][this.col] == curMap[this.row][this.col + 2]) {
                            int[] nArray = curMap[this.row];
                            int n2 = this.col;
                            nArray[n2] = nArray[n2] + 1;
                            int[] nArray2 = curMap[this.row];
                            int n3 = this.col + 1;
                            nArray2[n3] = nArray2[n3] + 1;
                            int[] nArray3 = curMap[this.row];
                            int n4 = this.col + 2;
                            nArray3[n4] = nArray3[n4] + 1;
                            int[] nArray4 = curMap[this.row + 1];
                            int n5 = this.col + 1;
                            nArray4[n5] = nArray4[n5] + 1;
                            bl = false;
                        } else if (curMap[this.row][this.col] == curMap[this.row][this.col + 1] && curMap[this.row][this.col + 1] == curMap[this.row + 1][this.col + 1]) {
                            int[] nArray = curMap[this.row];
                            int n6 = this.col;
                            nArray[n6] = nArray[n6] + 1;
                            int[] nArray5 = curMap[this.row];
                            int n7 = this.col + 1;
                            nArray5[n7] = nArray5[n7] + 1;
                            int[] nArray6 = curMap[this.row + 1];
                            int n8 = this.col + 1;
                            nArray6[n8] = nArray6[n8] + 1;
                            bl = false;
                        } else if (curMap[this.row][this.col] == curMap[this.row + 1][this.col] && curMap[this.row][this.col] == curMap[this.row][this.col + 1]) {
                            int[] nArray = curMap[this.row];
                            int n9 = this.col;
                            nArray[n9] = nArray[n9] + 1;
                            int[] nArray7 = curMap[this.row];
                            int n10 = this.col + 1;
                            nArray7[n10] = nArray7[n10] + 1;
                            int[] nArray8 = curMap[this.row + 1];
                            int n11 = this.col;
                            nArray8[n11] = nArray8[n11] + 1;
                            bl = false;
                        } else if (curMap[this.row][this.col] == curMap[this.row][this.col + 1] && curMap[this.row][this.col] == curMap[this.row][this.col + 2]) {
                            int[] nArray = curMap[this.row];
                            int n12 = this.col;
                            nArray[n12] = nArray[n12] + 1;
                            int[] nArray9 = curMap[this.row];
                            int n13 = this.col + 1;
                            nArray9[n13] = nArray9[n13] + 1;
                            int[] nArray10 = curMap[this.row];
                            int n14 = this.col + 2;
                            nArray10[n14] = nArray10[n14] + 1;
                            bl = false;
                        } else if (curMap[this.row][this.col] == curMap[this.row + 1][this.col]) {
                            int[] nArray = curMap[this.row];
                            int n15 = this.col;
                            nArray[n15] = nArray[n15] + 1;
                            int[] nArray11 = curMap[this.row + 1];
                            int n16 = this.col;
                            nArray11[n16] = nArray11[n16] + 1;
                            bl = false;
                        } else if (curMap[this.row][this.col] == curMap[this.row][this.col + 1]) {
                            int[] nArray = curMap[this.row];
                            int n17 = this.col;
                            nArray[n17] = nArray[n17] + 1;
                            int[] nArray12 = curMap[this.row];
                            int n18 = this.col + 1;
                            nArray12[n18] = nArray12[n18] + 1;
                            bl = false;
                        }
                    }
                    ++this.col;
                }
                ++this.row;
            }
            if (bl) continue;
            bl2 = true;
            this.update();
            this.delay(DELAY);
            if (n != 0 || this.state == SHOW_SOLUTION) continue;
            this.state = WON;
            bl = true;
        } while (!bl);
        if (bl3 && this.state != WON) {
            this.shrinkBlocksEffect();
        }
        return bl2;
    }

    protected void shrinkBlocksEffect() {
    }

    private void saveMap() {
        this.oldMoves = this.moves;
        this.row = 0;
        while (this.row < 8) {
            System.arraycopy(curMap[this.row], 0, oldMap[this.row], 0, 10);
            ++this.row;
        }
    }

    private void moveBlock(int n) {
        if (this.notSelected()) {
            return;
        }
        this.selectedX += n;
        if (this.selectedX < 0) {
            this.selectedX = 0;
            return;
        }
        if (this.selectedX > 9) {
            this.selectedX = 9;
            return;
        }
        if (curMap[this.selectedY][this.selectedX] >= 2304) {
            this.saveMap();
            ++this.moves;
            NormalBoard.curMap[this.selectedY][this.selectedX] = curMap[this.selectedY][this.selectedX - n];
            NormalBoard.curMap[this.selectedY][this.selectedX - n] = 2304;
        } else {
            this.unSelect();
        }
    }

    private void moveBlockLeft() {
        this.moveBlock(-1);
    }

    private void moveBlockRight() {
        this.moveBlock(1);
    }

    public void reset() {
        this.paused = true;
        this.unSelect();
        this.moves = 0;
        this.oldMoves = 0;
        this.state = NORMAL;
        this.oldState = NORMAL;
        this.solutionStep = 0;
        this.clearRect(this.offGraphics, -this.translateX, -this.translateY, this.getWidth(), this.getHeight());
        this.updateLevel();
        this.update();
    }

    public void showSolution() {
        this.reset();
        this.oldState = SHOW_SOLUTION;
        this.state = SHOW_SOLUTION;
        this.showArrow = true;
    }

    public void undoMove() {
        int n;
        this.row = 0;
        while (this.row < 8) {
            this.col = 0;
            while (this.col < 10) {
                if (curMap[this.row][this.col] != oldMap[this.row][this.col]) {
                    n = curMap[this.row][this.col];
                    NormalBoard.curMap[this.row][this.col] = oldMap[this.row][this.col];
                    NormalBoard.oldMap[this.row][this.col] = n;
                }
                ++this.col;
            }
            ++this.row;
        }
        n = this.moves;
        this.moves = this.oldMoves;
        this.oldMoves = n;
        n = this.state;
        this.oldState = this.state;
        this.state = n;
        this.unSelect();
        this.update();
    }

    private void update() {
        this.repaint();
        this.serviceRepaints();
    }

    public void pause(boolean bl) {
        this.paused = bl;
    }

    private void blinkCursor() {
        int n = this.offGraphics.getColor();
        if (!this.notSelected()) {
            this.offGraphics.setColor(255, 128, 0);
        } else if (this.cursorState == 0) {
            this.offGraphics.setColor(255, 0, 255);
            this.cursorState = 1;
        } else {
            this.offGraphics.setColor(0, 0, 255);
            this.cursorState = 0;
        }
        this.offGraphics.fillRect(this.cursorX * 14 - 2, this.cursorY * 14 - 2, 18, 18);
        this.offGraphics.setColor(n);
        Block.setBlock(curMap[this.cursorY][this.cursorX]);
        Block.paint(this.offGraphics, this.cursorX * 14, this.cursorY * 14);
    }

    public void run() {
        while (true) {
            this.delay(1000);
            if (!this.notSelected() || this.paused) continue;
            this.update();
        }
    }

    private void delay(int n) {
        try {
            Thread.currentThread();
            Thread.sleep(n);
        }
        catch (Exception exception) {
            this.paused = true;
        }
    }

    protected void levelCleared() {
        if (this.level.isHighestLevel()) {
            this.parent.highestLevelReached();
        } else {
            this.level.setLastLevel(this.level.getId() + 1);
            this.level.loadNextLevel();
            this.reset();
        }
    }
}

