/*
 * Decompiled with CFR 0.152.
 */
package com.ixisoft.games.swappuz;

import com.ixisoft.games.score.ScoreRanker;
import com.ixisoft.games.score.ScoreRankerListener;
import com.ixisoft.games.swappuz.BestTimeScreen;
import com.ixisoft.games.swappuz.PuzzleCanvas;
import com.ixisoft.games.swappuz.SwapPuzzleMIDlet$1;
import com.ixisoft.games.swappuz.TimeScoreFactory;
import com.ixisoft.midlet.imageloader.ImageLoader;
import com.ixisoft.midlet.region.BorderRegion;
import com.ixisoft.midlet.region.ImageRegion;
import com.ixisoft.midlet.region.StringRegion;
import com.ixisoft.midlet.util.ContainerCanvas;
import com.ixisoft.midlet.util.MIDletContext;
import com.ixisoft.midlet.util.MIDletContextImpl;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;

public class SwapPuzzleMIDlet
extends MIDlet
implements CommandListener,
ScoreRankerListener {
    Display display = Display.getDisplay((MIDlet)this);
    private final MIDletContext context = new MIDletContextImpl(this);
    ScoreRanker ranker;
    private static final String RMS_PUZZLE_SCORE = "puzzle-time";
    static final String KEY_RANKER = "ranker";
    boolean justCreated = true;
    ContainerCanvas openScreen;
    BestTimeScreen scoreScreen;
    StringRegion status = new StringRegion();
    private static final int HELP_PAGES = 2;
    private static final int ABOUT_PAGES = 2;
    private Vector helpScreens = new Vector();
    private Vector aboutScreens = new Vector();
    private PuzzleCanvas gameScreen;
    private static Command CMD_GAME = new Command("Start", 4, 0);
    private static Command CMD_QUIT = new Command("Quit", 6, 1);
    private static Command CMD_HELP = new Command("Help", 5, 2);
    private static Command CMD_ABOUT = new Command("About", 5, 3);
    private static Command CMD_NEXT = new Command("Next", 4, 101);
    static Command CMD_MAIN = new Command("Home", 6, 102);
    private static Command CMD_PREV = new Command("Prev", 2, 103);
    static Command CMD_SCORE = new Command("HiScore", 1, 140);
    static Command CMD_RESET = new Command("Clear", 1, 150);
    static Command CMD_RETURN = new Command("Return", 2, 20);
    static Command CMD_PLAY = new Command("Play", 4, 10);
    static final Font SMALL_FONT = Font.getFont((int)64, (int)0, (int)8);

    public SwapPuzzleMIDlet() {
        this.status.setFont(SMALL_FONT);
        this.status.setHorizontalAlignment(1);
        this.ranker = new ScoreRanker(RMS_PUZZLE_SCORE, new TimeScoreFactory(), 3);
        this.context.putAttribute(KEY_RANKER, this.ranker);
    }

    protected void startApp() {
        try {
            this.prepareOpenScreen();
            this.display.setCurrent((Displayable)this.openScreen);
        }
        catch (IOException iOException) {
            this.showError(iOException);
            return;
        }
        if (this.justCreated) {
            this.justCreated = false;
            ImageLoader imageLoader = ImageLoader.getInstance();
            imageLoader.putAlias("PUZZLE-0", "/puzzle/puz1.png");
            imageLoader.putAlias("PUZZLE-1", "/puzzle/puz2.png");
            imageLoader.putAlias("PUZZLE-2", "/puzzle/puz3.png");
            imageLoader.putAlias("PUZZLE-3", "/puzzle/puz1.png");
            imageLoader.putAlias("PUZZLE-4", "/puzzle/puz2.png");
            imageLoader.putAlias("PUZZLE-5", "/puzzle/puz3.png");
            imageLoader.putAlias("PUZZLE-6", "/puzzle/puz1.png");
            imageLoader.putAlias("PUZZLE-7", "/puzzle/puz2.png");
            imageLoader.putAlias("PUZZLE-8", "/puzzle/puz3.png");
            imageLoader.putAlias("PUZZLE-9", "/puzzle/puz1.png");
            imageLoader.putAlias("PUZZLE-10", "/puzzle/puz2.png");
            imageLoader.putAlias("PUZZLE-11", "/puzzle/puz3.png");
            try {
                this.ranker.load(this);
                this.status.setValue("");
            }
            catch (Exception exception) {
                this.status.setValue("RMS error. No score saving.");
            }
            this.status.repaintRegion();
        }
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean bl) {
        if (this.gameScreen != null) {
            this.gameScreen.destroy();
        }
        this.display.setCurrent(null);
    }

    public void commandAction(Command command, Displayable displayable) {
        try {
            int n = this.helpScreens.indexOf(displayable);
            if (n >= 0) {
                this.commandHelpAction(command, n);
            } else {
                n = this.aboutScreens.indexOf(displayable);
                if (n >= 0) {
                    this.commandAboutAction(command, n);
                } else if (command == CMD_QUIT) {
                    this.notifyDestroyed();
                } else if (command == CMD_ABOUT) {
                    this.prepareAboutScreen(0);
                    this.display.setCurrent((Displayable)this.aboutScreens.firstElement());
                } else if (command == CMD_HELP) {
                    this.prepareHelpScreen(0);
                    this.display.setCurrent((Displayable)this.helpScreens.firstElement());
                } else if (command == CMD_GAME) {
                    this.prepareGameScreen();
                    this.display.setCurrent((Displayable)this.gameScreen);
                    this.gameScreen.repaint();
                } else if (command == CMD_RETURN) {
                    this.display.setCurrent((Displayable)this.openScreen);
                } else if (command == CMD_PLAY) {
                    this.gameScreen.startGame();
                } else if (command == CMD_SCORE) {
                    this.prepareScoreScreen();
                    this.scoreScreen.refresh();
                    this.display.setCurrent((Displayable)this.scoreScreen);
                } else if (command == CMD_RESET) {
                    this.scoreScreen.reset();
                } else if (command == CMD_MAIN) {
                    this.display.setCurrent((Displayable)this.openScreen);
                }
            }
        }
        catch (IOException iOException) {
            this.status.setValue("Loading error. Try later.");
            this.status.repaintRegion();
        }
        catch (Exception exception) {
            this.showError(exception);
        }
    }

    private void commandHelpAction(Command command, int n) throws IOException {
        if (command == CMD_MAIN) {
            this.display.setCurrent((Displayable)this.openScreen);
        } else if (command == CMD_NEXT) {
            this.prepareHelpScreen(n + 1);
            this.display.setCurrent((Displayable)this.helpScreens.elementAt(n + 1));
        } else if (command == CMD_PREV) {
            this.display.setCurrent((Displayable)this.helpScreens.elementAt(n - 1));
        }
    }

    private void commandAboutAction(Command command, int n) throws IOException {
        if (command == CMD_MAIN) {
            this.display.setCurrent((Displayable)this.openScreen);
        } else if (command == CMD_NEXT) {
            this.prepareAboutScreen(n + 1);
            this.display.setCurrent((Displayable)this.aboutScreens.elementAt(n + 1));
        } else if (command == CMD_PREV) {
            this.display.setCurrent((Displayable)this.aboutScreens.elementAt(n - 1));
        }
    }

    private void showError(Exception exception) {
        this.showError(exception, null);
    }

    private void showError(Exception exception, String string) {
        Form form = new Form("Error");
        if (string != null) {
            form.append((Item)new StringItem(null, string));
        }
        if (exception != null) {
            form.append((Item)new StringItem(exception.getClass().getName(), exception.getMessage()));
        }
        form.addCommand(CMD_QUIT);
        this.display.setCurrent((Displayable)form);
    }

    private void prepareOpenScreen() throws IOException {
        if (this.openScreen != null) {
            return;
        }
        Image image = Image.createImage((String)"/puzzle/game-logo.png");
        SwapPuzzleMIDlet$1 swapPuzzleMIDlet$1 = new SwapPuzzleMIDlet$1(this);
        int n = swapPuzzleMIDlet$1.getWidth();
        int n2 = swapPuzzleMIDlet$1.getHeight();
        StringRegion stringRegion = new StringRegion();
        stringRegion.setValue(this.getAppProperty("MIDlet-Name"));
        BorderRegion borderRegion = new BorderRegion(3);
        borderRegion.setBackground(0xAAAAAA);
        ImageRegion imageRegion = new ImageRegion(image, 0, 0);
        imageRegion.setHorizontalCentered(true);
        imageRegion.setVerticalCentered(true);
        StringRegion stringRegion2 = new StringRegion();
        StringRegion stringRegion3 = new StringRegion();
        stringRegion2.setValue("(c)2001 ixisoft Ltd.");
        stringRegion3.setValue("All rights reserved.");
        stringRegion2.setFont(SMALL_FONT);
        stringRegion3.setFont(SMALL_FONT);
        BorderRegion borderRegion2 = new BorderRegion(3);
        swapPuzzleMIDlet$1.addRegion(borderRegion, 0, 0, n, 28);
        swapPuzzleMIDlet$1.addRegion(stringRegion, 2, 2, n - 4, 24);
        swapPuzzleMIDlet$1.addRegion(imageRegion, 0, 30, n, 120);
        swapPuzzleMIDlet$1.addRegion(stringRegion2, 2, 152, n - 4, 24);
        swapPuzzleMIDlet$1.addRegion(stringRegion3, 2, 176, n - 4, 24);
        swapPuzzleMIDlet$1.addRegion(borderRegion2, 2, 202, n - 4, 28);
        swapPuzzleMIDlet$1.addRegion(this.status, 4, 204, n - 8, 24);
        swapPuzzleMIDlet$1.addCommand(CMD_GAME);
        swapPuzzleMIDlet$1.addCommand(CMD_QUIT);
        swapPuzzleMIDlet$1.addCommand(CMD_HELP);
        swapPuzzleMIDlet$1.addCommand(CMD_ABOUT);
        swapPuzzleMIDlet$1.addCommand(CMD_SCORE);
        swapPuzzleMIDlet$1.setCommandListener(this);
        this.openScreen = swapPuzzleMIDlet$1;
    }

    private void prepareHelpScreen(int n) throws IOException {
        Vector vector = this.helpScreens;
        synchronized (vector) {
            if (this.helpScreens.size() > n) {
                return;
            }
            Form form = new Form("Help Page " + (n + 1) + "/" + 2);
            switch (n) {
                case 0: {
                    form.append((Item)new StringItem(null, "A random picture is shown at the start of a game. Click \"Play\" to scramble the picture. Click and select two pieces to swap. Clicking it again to de-select it. If any piece is in the correct position, it is locked in place."));
                    break;
                }
                case 1: {
                    form.append((Item)new StringItem(null, "Time spent is shown when all pieces are rearranged.\nClick \"New\" to play a new game.\nYou can review the original picture anytime by clicking \"Hints\" and return to the game by clicking \"Done\"."));
                }
            }
            if (n < 1) {
                form.addCommand(CMD_NEXT);
            }
            if (n > 0) {
                form.addCommand(CMD_PREV);
            }
            form.addCommand(CMD_MAIN);
            form.setCommandListener((CommandListener)this);
            this.helpScreens.addElement(form);
        }
    }

    private void prepareAboutScreen(int n) throws IOException {
        Vector vector = this.aboutScreens;
        synchronized (vector) {
            if (this.aboutScreens.size() > n) {
                return;
            }
            Form form = new Form("About Page " + (n + 1) + "/" + 2);
            switch (n) {
                case 0: {
                    form.append((Item)new StringItem("Family: ", "ixiTainment"));
                    form.append((Item)new StringItem("Product: ", this.getAppProperty("MIDlet-Name")));
                    form.append((Item)new StringItem("Version: ", "v1.0-XA (Build " + this.getAppProperty("MIDlet-Version") + ")"));
                    form.append((Item)new StringItem("Created-by: ", "ixisoft Ltd."));
                    break;
                }
                case 1: {
                    form.append((Item)new StringItem("Email: ", "enq1@ixisoft.com"));
                    form.append((Item)new StringItem("URL: ", "www.ixisoft.com/ixiTainment/SwapPuzzle/"));
                    form.append((Item)new StringItem("URL: ", "www.ixisoft.com"));
                }
            }
            if (n < 1) {
                form.addCommand(CMD_NEXT);
            }
            if (n > 0) {
                form.addCommand(CMD_PREV);
            }
            form.addCommand(CMD_MAIN);
            form.setCommandListener((CommandListener)this);
            this.aboutScreens.addElement(form);
        }
    }

    private void prepareGameScreen() throws IOException {
        this.status.setValue("Loading, please wait...");
        this.status.repaintRegion();
        this.openScreen.serviceRepaints();
        PuzzleCanvas puzzleCanvas = new PuzzleCanvas();
        puzzleCanvas.addCommand(CMD_PLAY);
        puzzleCanvas.addCommand(CMD_RETURN);
        puzzleCanvas.setCommandListener(this);
        puzzleCanvas.init(this.context);
        this.gameScreen = puzzleCanvas;
        this.status.setValue(null);
    }

    private void prepareScoreScreen() {
        BestTimeScreen bestTimeScreen = new BestTimeScreen(this.ranker);
        bestTimeScreen.addCommand(CMD_MAIN);
        bestTimeScreen.addCommand(CMD_RESET);
        bestTimeScreen.setCommandListener(this);
        this.scoreScreen = bestTimeScreen;
    }

    public void scoreUpdating() {
    }

    public void scoreUpdated() {
    }

    public void scoreLoading() {
        this.status.setValue("score loading");
        this.status.repaintRegion();
    }

    public void scoreLoaded() {
        this.status.setValue("score loaded");
        this.status.repaintRegion();
    }

    static void access$000(SwapPuzzleMIDlet swapPuzzleMIDlet) throws IOException {
        swapPuzzleMIDlet.prepareGameScreen();
    }

    static PuzzleCanvas access$100(SwapPuzzleMIDlet swapPuzzleMIDlet) {
        return swapPuzzleMIDlet.gameScreen;
    }

    static void access$200(SwapPuzzleMIDlet swapPuzzleMIDlet, Exception exception) {
        swapPuzzleMIDlet.showError(exception);
    }
}

