/*
 * Decompiled with CFR 0.152.
 */
package com.ixisoft.midlet.imageloader;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Image;

public class ImageLoader {
    private static ImageLoader instance;
    private Hashtable imageMap = new Hashtable();
    private Hashtable aliasMap = new Hashtable();

    public static ImageLoader getInstance() {
        if (instance == null) {
            ImageLoader.ensureInstanceCreated();
        }
        return instance;
    }

    private static synchronized void ensureInstanceCreated() {
        if (instance == null) {
            instance = new ImageLoader();
        }
    }

    private ImageLoader() {
    }

    public Image getImage(String string) throws IOException {
        return this.getImage(string, false);
    }

    public Image getImage(String string, boolean bl) throws IOException {
        String string2;
        if (string == null) {
            throw new NullPointerException();
        }
        if (!bl && (string2 = (String)this.aliasMap.get(string)) != null) {
            string = string2;
        }
        if ((string2 = (Image)this.imageMap.get(string)) == null) {
            string2 = this.loadImage(string);
        }
        return string2;
    }

    public Image putImage(String string, Image image) {
        if (string == null || image == null) {
            throw new NullPointerException();
        }
        return this.imageMap.put(string, image);
    }

    private synchronized Image loadImage(String string) throws IOException {
        Image image = (Image)this.imageMap.get(string);
        if (image == null) {
            if (string.startsWith("http://")) {
                HttpConnection httpConnection = null;
                InputStream inputStream = null;
                try {
                    httpConnection = (HttpConnection)Connector.open((String)string);
                    if (httpConnection.getResponseCode() != 200) {
                        throw new IOException("HttpConnection: " + httpConnection.getResponseMessage());
                    }
                    inputStream = httpConnection.openInputStream();
                    long l = httpConnection.getLength();
                    if (l < 0L) {
                        throw new IOException("HttpConncetion: unknown content length");
                    }
                    byte[] byArray = new byte[(int)l];
                    inputStream.read(byArray);
                    image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (httpConnection != null) {
                        httpConnection.close();
                    }
                }
            } else {
                image = Image.createImage((String)string);
            }
        }
        return image;
    }

    public void putAlias(String string, String string2) {
        this.aliasMap.put(string, string2);
    }

    public void removeAlias(String string) {
        this.aliasMap.remove(string);
    }
}

