/*
 * Decompiled with CFR 0.152.
 */
package com.ixisoft.midlet.region;

import com.ixisoft.midlet.imageloader.ImageLoader;
import com.ixisoft.midlet.util.Region;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ImageRegion
extends Region {
    private String locator;
    private Image image;
    private int xOffset;
    private int yOffset;
    private boolean vcenter;
    private boolean hcenter;

    public ImageRegion(String string) {
        this(string, null, 0, 0);
    }

    public ImageRegion(String string, int n, int n2) {
        this(string, null, n, n2);
    }

    public ImageRegion(Image image, int n, int n2) {
        this(null, image, n, n2);
    }

    public ImageRegion(String string, Image image, int n, int n2) {
        if (string != null) {
            this.setImageLocator(string);
        } else {
            this.setImage(image);
        }
        this.setImageOffset(n, n2);
    }

    public void setImageLocator(String string) {
        this.setImageLocator(string, 0, 0);
    }

    public void setImageLocator(String string, int n, int n2) {
        this.locator = string;
        this.image = null;
        this.setImageOffset(n, n2);
    }

    public void setImage(Image image) {
        this.setImage(image, 0, 0);
    }

    public void setImage(Image image, int n, int n2) {
        this.image = image;
        this.locator = null;
        this.setImageOffset(n, n2);
    }

    public void setImageOffset(int n, int n2) {
        this.xOffset = n;
        this.yOffset = n2;
    }

    public Image getImage() throws IOException {
        if (this.image == null) {
            this.prefetchImage();
        }
        return this.image;
    }

    public synchronized void prefetchImage() throws IOException {
        if (this.image == null && this.locator != null) {
            this.image = ImageLoader.getInstance().getImage(this.locator);
            this.locator = null;
        }
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void setVerticalCentered(boolean bl) {
        this.vcenter = bl;
    }

    public void setHorizontalCentered(boolean bl) {
        this.hcenter = bl;
    }

    public void paint(Graphics graphics) {
        Image image = null;
        try {
            image = this.getImage();
            if (image == null) {
                return;
            }
            if (this.hcenter && this.vcenter) {
                graphics.drawImage(image, this.getWidth() / 2, this.getHeight() / 2, 3);
            } else if (this.hcenter) {
                graphics.drawImage(image, this.getWidth() / 2, 0, 17);
            } else if (this.vcenter) {
                graphics.drawImage(image, 0, this.getHeight() / 2, 18);
            } else {
                graphics.drawImage(image, -this.xOffset, -this.yOffset, 20);
            }
        }
        catch (IOException iOException) {
            graphics.drawString("loading error", 0, 0, 20);
        }
    }
}

