/*
 * Decompiled with CFR 0.152.
 */
import com.siemens.mp.game.Melody;
import com.siemens.mp.game.MelodyComposer;
import com.siemens.mp.game.Vibrator;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class GameScreen
extends Canvas
implements Runnable {
    Bitmaps bmps;
    Vibrator vbr = new Vibrator();
    CPlayGround pgrnd = new CPlayGround(this.bmps);
    CSnkHead mshd = new CSnkHead(this.bmps, this.pgrnd);
    CSnkTail mtl = new CSnkTail(this.bmps, this.pgrnd);
    CFood fod = new CFood(this.bmps);
    CFoodEx fodx = new CFoodEx(this.bmps);
    Graphics g;
    boolean repainted;
    boolean alive;
    boolean SnakeAlive = true;
    int SnakeDir = -1;
    Snake csnk;
    int mSnakeSpeed;
    static final int SNAKE_MAXLEN = 200;
    Melody melFoodEx;
    Melody melDie;
    Melody melBreak;
    boolean tonePlayed = false;
    Thread thread;

    public GameScreen(Snake msnk, Bitmaps mbmps) {
        this.csnk = msnk;
        this.mSnakeSpeed = this.csnk.getSnakeSpeed() - 100;
        this.bmps = mbmps;
        this.initGame();
    }

    public void initMelody() {
        int i;
        MelodyComposer comp = new MelodyComposer();
        comp.setBPM(135);
        try {
            comp.appendNote(Bitmaps.FoodMelody[0], Bitmaps.FoodMelody[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.melFoodEx = comp.getMelody();
        comp.resetMelody();
        try {
            for (i = 0; i < 5; ++i) {
                comp.appendNote(Bitmaps.ScoreMelody[i][0], Bitmaps.ScoreMelody[i][1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.melBreak = comp.getMelody();
        comp.resetMelody();
        try {
            for (i = 0; i < 3; ++i) {
                comp.appendNote(Bitmaps.DieMelody[i][0], Bitmaps.DieMelody[i][1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.melDie = comp.getMelody();
    }

    public void initGame() {
        CSnkBody sbd = new CSnkBody(this.bmps, this.pgrnd);
        if (this.csnk.getSnakeMaze() != 0) {
            this.pgrnd.setMaze(Bitmaps.Mazes[this.csnk.getSnakeMaze() - 1]);
        }
        this.mshd.setNext(sbd);
        this.mshd.setPos(96 / 2, 28, 0);
        this.mtl.setPrev(sbd);
        sbd.setNext(this.mtl);
        sbd.setPos(96 / 2 - 4, 28, 0);
        this.mtl.setPos(96 / 2 - 8, 28, 0);
        this.fod.newPos(this.pgrnd, this.mshd, this.fodx);
        this.fodx.newPos(this.pgrnd, this.mshd, this.fod);
        this.alive = true;
        this.repainted = false;
        this.initMelody();
    }

    private void addSnkItem(CSnkTail tl) {
        CSnkBody sbd = new CSnkBody(this.bmps, this.pgrnd);
        sbd.addMeToList(tl);
        this.mshd.IncLen();
    }

    public void DisplayScore(int Score) {
        int[] num;
        num = new int[]{Score / 100, (Score - num[0] * 100) / 10, Score - (num[0] * 100 + num[1] * 10)};
        this.g.drawImage(Bitmaps.Nums[num[0]], 4 - 2, 0, 20);
        this.g.drawImage(Bitmaps.Nums[num[1]], 4 + 2, 0, 20);
        this.g.drawImage(Bitmaps.Nums[num[2]], 4 + 6, 0, 20);
        this.g.drawImage(Bitmaps.Nums[0], 4 + 10, 0, 20);
        if (this.csnk.getSnakeAudio() && Score > this.csnk.getScore() && !this.tonePlayed) {
            this.melBreak.play();
            this.tonePlayed = true;
        }
    }

    public void paint(Graphics g) {
        this.g = g;
        if (!this.repainted) {
            this.repainted = true;
            g.setColor(0, 0, 0);
            g.drawRect(4 - 2, 8 - 2, 96 - 1, 52 - 1);
            this.pgrnd.DrawMaze(g);
            this.DisplayScore(this.mshd.getScore());
            g.drawImage(Bitmaps.fsLogo, 96 - 39, 0, 20);
            this.mshd.ReDraw(g);
            if (this.thread == null) {
                this.thread = new Thread(this);
                this.thread.setPriority(10);
                this.thread.start();
            }
        }
    }

    public void run() {
        while (this.alive) {
            this.repaint();
            if (this.SnakeAlive) {
                if (this.mshd.getLen() > 14) {
                    if (this.fodx.TimerTick(this.g) && this.fodx.getVisible()) {
                        this.fodx.newPos(this.pgrnd, this.mshd, this.fod);
                    }
                    this.fodx.Draw(this.g);
                    if (this.fodx.getVisible() && this.fodx.isEaten(this.mshd)) {
                        this.addSnkItem(this.mtl);
                        this.mshd.IncScore(2);
                        this.DisplayScore(this.mshd.getScore());
                        if (this.csnk.getSnakeAudio()) {
                            this.melFoodEx.play();
                        }
                        if (this.csnk.getSnakeVibra()) {
                            Vibrator.triggerVibrator((int)90);
                        }
                        this.fodx.ResetTimer();
                        this.fodx.newPos(this.pgrnd, this.mshd, this.fod);
                    }
                }
                this.fod.Draw(this.g);
                this.SnakeAlive = this.mshd.Move(this.SnakeDir);
                if (this.mshd.getLen() > 200) {
                    this.SnakeAlive = false;
                }
                this.mtl.Clear(this.g);
                this.mshd.Draw(this.g);
                this.mshd.next.Draw(this.g);
                this.mtl.Draw(this.g);
                if (this.fod.isEaten(this.mshd)) {
                    this.addSnkItem(this.mtl);
                    this.mshd.IncScore(1);
                    this.DisplayScore(this.mshd.getScore());
                    if (this.csnk.getSnakeVibra()) {
                        Vibrator.triggerVibrator((int)70);
                    }
                    this.fod.newPos(this.pgrnd, this.mshd, this.fodx);
                }
            } else if (this.mshd.getLen() > 200) {
                Font largeFont = Font.getFont((int)0, (int)1, (int)0);
                this.g.setFont(largeFont);
                this.g.drawString("Snake Overflow", this.getWidth() / 2, this.getHeight() / 2, 65);
                this.alive = false;
            } else {
                if (this.csnk.getSnakeVibra()) {
                    Vibrator.triggerVibrator((int)70);
                }
                this.mSnakeSpeed = 80;
                this.alive = this.mshd.DrawDeath(this.g);
                if (this.csnk.getSnakeAudio() && !this.alive) {
                    this.melDie.play();
                }
            }
            try {
                Thread.sleep(this.mSnakeSpeed);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    public void StopGame() {
        this.csnk.SetResumable(this.SnakeAlive);
        if (!this.SnakeAlive) {
            this.csnk.setScore(this.mshd.getScore());
        }
        this.alive = false;
        this.thread = null;
        this.csnk.Splash();
    }

    public void ResumeGame() {
        this.alive = true;
        this.repainted = false;
    }

    public void keyPressed(int keyCode) {
        if (keyCode == 50) {
            this.SnakeDir = 3;
        }
        if (keyCode == 56) {
            this.SnakeDir = 2;
        }
        if (keyCode == 54) {
            this.SnakeDir = 0;
        }
        if (keyCode == 52) {
            this.SnakeDir = 1;
        }
        if (keyCode == 49 || keyCode == 51) {
            this.SnakeDir = this.SnakeDir > 1 ? (keyCode == 51 ? 0 : 1) : 3;
        }
        if (keyCode == 57 || keyCode == 55) {
            this.SnakeDir = this.SnakeDir > 1 ? (keyCode == 55 ? 1 : 0) : 2;
        }
        if (keyCode == -12) {
            this.StopGame();
        }
        if (keyCode == -11 && !this.alive) {
            this.csnk.setScore(this.mshd.getScore());
            this.csnk.NewGame();
        }
    }

    static {
        SNAKE_MAXLEN = 200;
    }
}

