/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class SetupScreen
extends Canvas
implements Backable {
    Bitmaps bmps;
    Snake csnk;
    Backable showinfo;
    Display cdisp;
    Graphics g;
    private static final int MENU_MAX = 4;
    private static final int SPEED_MAX = 5;
    private static final int MAZE_MAX = 5;
    private static final int VIBR_MAX = 4;
    private int MENU_POS = 0;
    private static final int MENU_SPEED = 0;
    private static final int MENU_MAZE = 1;
    private static final int MENU_VIBRA = 2;
    private static final int MENU_HS = 3;
    private int SPEED_POS = 0;
    private int MAZE_POS = 0;
    private int VIBR_POS = 1;

    public SetupScreen(Bitmaps mbmps, Snake snk) {
        this.bmps = mbmps;
        this.csnk = snk;
        this.SPEED_POS = 4 - (snk.getSnakeSpeed() / 50 - 3);
        this.MAZE_POS = snk.getSnakeMaze();
        this.VIBR_POS = 0;
        if (snk.getSnakeVibra()) {
            this.VIBR_POS = 1;
        }
        if (snk.getSnakeAudio()) {
            this.VIBR_POS = 2;
        }
        if (snk.getSnakeAudio() && snk.getSnakeVibra()) {
            this.VIBR_POS = 3;
        }
    }

    public void shows(Display disp, Backable go_back) {
        this.showinfo = go_back;
        this.cdisp = disp;
        this.shows();
    }

    public void shows() {
        this.cdisp.setCurrent((Displayable)this);
    }

    public void keyPressed(int keyCode) {
        switch (this.getGameAction(keyCode)) {
            case 6: {
                this.setMenuPos(1);
                break;
            }
            case 1: {
                this.setMenuPos(0);
                break;
            }
            case 5: {
                this.setMenuValue(1);
                break;
            }
            case 2: {
                this.setMenuValue(0);
                break;
            }
            case 0: {
                this.CloseBox();
            }
        }
    }

    private void setMenuValue(int dir) {
        switch (this.MENU_POS) {
            case 0: {
                this.chgVal(dir, this.SPEED_POS, 5);
                this.DrawSpeed();
                break;
            }
            case 1: {
                this.chgVal(dir, this.MAZE_POS, 5);
                this.DrawMaze();
                break;
            }
            case 2: {
                this.chgVal(dir, this.VIBR_POS, 4);
                this.DrawVibra();
                break;
            }
            case 3: {
                this.csnk.resetScore();
                this.g.drawString("Done", 74, 50, 20);
            }
        }
    }

    private void setMenuPos(int dir) {
        this.g.setColor(255, 255, 255);
        this.g.fillRect(0, 20 + 10 * this.MENU_POS, 4, 7);
        this.g.setColor(0, 0, 0);
        if (dir == 0) {
            --this.MENU_POS;
            if (this.MENU_POS < 0) {
                this.MENU_POS = 3;
            }
        } else {
            ++this.MENU_POS;
            if (this.MENU_POS == 4) {
                this.MENU_POS = 0;
            }
        }
        this.g.drawImage(Bitmaps.Setups[0], 0, 20 + 10 * this.MENU_POS, 20);
    }

    private void chgVal(int dir, int what, int max) {
        if (dir == 0) {
            if (--what < 0) {
                what = max - 1;
            }
        } else if (++what == max) {
            what = 0;
        }
        if (this.MENU_POS == 0) {
            this.SPEED_POS = what;
        }
        if (this.MENU_POS == 1) {
            this.MAZE_POS = what;
        }
        if (this.MENU_POS == 2) {
            this.VIBR_POS = what;
        }
    }

    private void DrawMaze() {
        this.g.drawImage(Bitmaps.Setups[6], 44, 32, 20);
        this.g.drawImage(Bitmaps.Setups[5], 93, 32, 20);
        this.g.setColor(255, 255, 255);
        this.g.fillRect(49, 30, 43, 9);
        this.g.setColor(0, 0, 0);
        this.g.drawString(Bitmaps.MazeNames[this.MAZE_POS], 52, 30, 20);
    }

    private void DrawVibra() {
        this.g.drawImage(Bitmaps.Setups[6], 44, 42, 20);
        this.g.drawImage(Bitmaps.Setups[5], 93, 42, 20);
        this.g.setColor(255, 255, 255);
        this.g.fillRect(49, 40, 43, 9);
        this.g.setColor(0, 0, 0);
        this.g.drawString(Bitmaps.FxNames[this.VIBR_POS], 52, 40, 20);
    }

    private void DrawSpeed() {
        this.g.setColor(255, 255, 255);
        this.g.fillRect(45, 20, 45, 9);
        this.g.setColor(0, 0, 0);
        this.g.drawLine(45, 24, 90, 24);
        this.g.drawImage(Bitmaps.Setups[1], 45 + this.SPEED_POS * 10, 22, 20);
        this.g.drawImage(Bitmaps.Setups[4], 93, 22, 20);
    }

    private void CloseBox() {
        this.csnk.setSnakeSpeed(350 - this.SPEED_POS * 50);
        this.csnk.setSnakeMaze(this.MAZE_POS);
        this.csnk.setSnakeAudio(false);
        this.csnk.setSnakeVibra(false);
        if (this.VIBR_POS == 1) {
            this.csnk.setSnakeVibra(true);
        }
        if (this.VIBR_POS == 2) {
            this.csnk.setSnakeAudio(true);
        }
        if (this.VIBR_POS == 3) {
            this.csnk.setSnakeAudio(true);
            this.csnk.setSnakeVibra(true);
        }
        this.showinfo.shows();
    }

    public void paint(Graphics g) {
        this.g = g;
        g.setColor(0, 0, 0);
        Font smallFont = Font.getFont((int)64, (int)0, (int)8);
        Font smallBoldFont = Font.getFont((int)64, (int)1, (int)8);
        Font largeFont = Font.getFont((int)0, (int)1, (int)0);
        g.setFont(largeFont);
        g.fillRect(0, 0, this.getWidth(), 13);
        g.setColor(255, 255, 255);
        g.drawString("Settings", this.getWidth() / 2, 1, 17);
        g.setColor(0, 0, 0);
        g.setFont(smallBoldFont);
        g.drawString("Speed", 7, 20, 20);
        g.drawString("Maze", 7, 30, 20);
        g.drawString("SFXs", 7, 40, 20);
        g.drawString("Reset Score", 7, 50, 20);
        this.DrawSpeed();
        g.drawImage(Bitmaps.Setups[0], 0, 20 + 10 * this.MENU_POS, 20);
        g.setFont(smallFont);
        this.DrawMaze();
        this.DrawVibra();
    }

    static {
        MENU_MAX = 4;
        SPEED_MAX = 5;
        MAZE_MAX = 5;
        VIBR_MAX = 4;
        MENU_SPEED = 0;
        MENU_MAZE = 1;
        MENU_VIBRA = 2;
        MENU_HS = 3;
    }
}

