/*
 * Decompiled with CFR 0.152.
 */
package jchessmid;

class chessboard {
    static final int OUT = 8888;
    static final int VOID = -1;
    static final int PAWN = 2;
    static final int ROOK = 6;
    static final int KNIGHT = 8;
    static final int BISSHOP = 10;
    static final int QUEEN = 12;
    static final int KING = 14;
    static final int FRESHKING = 114;
    static final int FRESHROOK = 106;
    int[] A = new int[144];
    int[] ExA;
    public int selectedm = 0;
    static final int ENPASSANT = 3;
    static final int CASTLE = 5;
    static final int CAASTLE = 7;
    static final int WHITE = 0;
    static final int BLACK = 1;
    int[] oldmove;
    int[] undoinf;
    static int oldmovesize;
    static int maxlistsize;
    int moves;
    int status;
    static final int CHECKMATE = 0;
    static final int CHECK = 1;
    static final int DRAW = 2;
    static final int OPEN = 3;
    static final int[] knightjump;
    static final int[] kingjump;
    static final int[] bisshopdir;
    static final int[] rookdir;
    static final int NULLMOVE = 0;

    chessboard() {
        this.ExA = new int[144];
        for (int i = 0; i < 144; ++i) {
            this.A[i] = 8888;
        }
        this.setup();
        this.oldmove = new int[oldmovesize];
        this.undoinf = new int[oldmovesize];
    }

    chessboard(chessboard c) {
        int i;
        for (i = 0; i < 144; ++i) {
            this.A[i] = c.A[i];
        }
        this.oldmove = new int[oldmovesize];
        this.undoinf = new int[oldmovesize];
        for (i = 0; i < oldmovesize; ++i) {
            this.oldmove[i] = c.oldmove[i];
            this.undoinf[i] = c.undoinf[i];
        }
        this.moves = c.moves;
        this.status = c.status;
    }

    void setup() {
        for (int x = 2; x < 10; ++x) {
            for (int j = 4; j < 8; ++j) {
                this.A[x + 12 * j] = -1;
            }
            int[] line = new int[]{106, 8, 10, 12, 114, 10, 8, 106};
            this.A[x + 24] = line[x - 2] + 0;
            this.A[x + 108] = line[x - 2] + 1;
            this.A[x + 36] = 2;
            this.A[x + 96] = 3;
        }
        this.moves = 0;
        this.status = 3;
    }

    void reset() {
        this.moves = 0;
        this.status = this.check(this.getside()) ? 1 : 3;
    }

    int getside() {
        return this.moves % 2;
    }

    int getking(int color) {
        int value1 = 14 + color;
        int value2 = 114 + color;
        for (int i = 0; i < 144; ++i) {
            if (this.A[i] != value1 && this.A[i] != value2) continue;
            return i;
        }
        return -1;
    }

    boolean attack(int f, int side) {
        int x;
        int i;
        for (i = 0; i < 8; ++i) {
            x = f + knightjump[i];
            if (this.inboard(x) && this.getpiece(x) == 8 && this.getside(x) == side) {
                return true;
            }
            x = f + kingjump[i];
            if (!this.inboard(x) || this.getpiece(x) != 14 || this.getside(x) != side) continue;
            return true;
        }
        block1: for (int d = 0; d < 4; ++d) {
            int p;
            x = f;
            for (i = 0; i < 7 && this.inboard(x += rookdir[d]); ++i) {
                if (this.getside(x) == -1) continue;
                p = this.getpiece(x);
                if (this.getside(x) != side || p != 6 && p != 12) break;
                return true;
            }
            x = f;
            for (i = 0; i < 7 && this.inboard(x += bisshopdir[d]); ++i) {
                if (this.getside(x) == -1) continue;
                p = this.getpiece(x);
                if (this.getside(x) != side || p != 10 && p != 12) continue block1;
                return true;
            }
        }
        int sign = side == 0 ? -1 : 1;
        x = f + sign * 11;
        for (i = 0; i < 2; ++i) {
            if (this.inboard(x) && this.getpiece(x) == 2 && this.getside(x) == side) {
                return true;
            }
            x = f + sign * 13;
        }
        return false;
    }

    static int newmove(int from, int to) {
        return from + 144 * to;
    }

    static int newmove(int from, int to, int newpiece) {
        return from + 144 * (to + 144 * newpiece);
    }

    static int movefrom(int move) {
        return move % 144;
    }

    static int moveto(int move) {
        return move / 144 % 144;
    }

    static int movenewpiece(int move) {
        return move / 20736;
    }

    boolean inboard(int f) {
        if (f < 0 || f >= 144) {
            return false;
        }
        return this.A[f] != 8888;
    }

    int getside(int field) {
        if (!this.inboard(field)) {
            return 0;
        }
        return this.A[field] % 2;
    }

    int getpiece(int field) {
        return this.A[field] % 100 - this.A[field] % 2;
    }

    boolean getfresh(int field) {
        return this.A[field] > 100;
    }

    void visualdomove(int move) {
        this.domove(move);
        int[] movelist = this.listofmoves();
        this.status = chessboard.getlength(movelist) > 0 ? (this.check(this.getside()) ? 1 : 3) : (this.check(this.getside()) ? 0 : 2);
    }

    void visualundomove() {
        this.undomove();
        this.status = this.check(this.getside()) ? 1 : 3;
    }

    void storemove(int m, int v, boolean f) {
        this.oldmove[this.moves % chessboard.oldmovesize] = m;
        this.undoinf[this.moves % chessboard.oldmovesize] = f ? v + 8888 : v;
    }

    int getstoredm(int m) {
        return this.oldmove[m % oldmovesize];
    }

    int getstoredvictim() {
        int value = this.undoinf[this.moves % oldmovesize];
        if (value < 8000) {
            return value;
        }
        return value - 8888;
    }

    boolean getstoredfresh() {
        return this.undoinf[this.moves % oldmovesize] > 8000;
    }

    void domove(int m) {
        if (m == 0) {
            this.storemove(m, -1, false);
            ++this.moves;
            return;
        }
        int from = chessboard.movefrom(m);
        int to = chessboard.moveto(m);
        int newpiece = chessboard.movenewpiece(m);
        boolean fresh = false;
        if (this.A[from] > 100) {
            fresh = true;
            this.A[from] = this.A[from] - 100;
        }
        int victim = this.A[to];
        this.A[to] = this.A[from];
        this.A[from] = -1;
        if (newpiece == 3) {
            this.A[to % 12 + 12 * (from / 12)] = -1;
        } else if (newpiece == 5) {
            this.A[from - from % 12 + 9] = -1;
            this.A[from - from % 12 + 7] = 6 + this.getside();
        } else if (newpiece == 7) {
            this.A[from - from % 12 + 2] = -1;
            this.A[from - from % 12 + 5] = 6 + this.getside();
        } else if (newpiece != 0) {
            this.A[to] = newpiece + this.getside();
        }
        this.storemove(m, victim, fresh);
        ++this.moves;
    }

    void undomove() {
        if (this.moves == 0) {
            return;
        }
        --this.moves;
        int m = this.getstoredm(this.moves);
        if (m == 0) {
            return;
        }
        int from = chessboard.movefrom(m);
        int to = chessboard.moveto(m);
        int newpiece = chessboard.movenewpiece(m);
        this.A[from] = this.A[to];
        this.A[to] = this.getstoredvictim();
        if (this.getstoredfresh()) {
            int n = from;
            this.A[n] = this.A[n] + 100;
        }
        if (newpiece == 3) {
            this.A[to % 12 + 12 * (from / 12)] = 2 + (1 - this.getside());
        } else if (newpiece == 5) {
            this.A[from - from % 12 + 7] = -1;
            this.A[from - from % 12 + 9] = 106 + this.getside();
        } else if (newpiece == 7) {
            this.A[from - from % 12 + 5] = -1;
            this.A[from - from % 12 + 2] = 106 + this.getside();
        } else if (newpiece != 0) {
            this.A[from] = 2 + this.getside();
        }
    }

    static int[] newlist() {
        int[] L = new int[maxlistsize + 1];
        L[0] = 0;
        return L;
    }

    static int getlength(int[] L) {
        return L[0];
    }

    static void add(int[] L, int i) {
        if (L[0] >= maxlistsize) {
            System.out.println("list overflow, raise maxlistsize.");
        }
        L[0] = L[0] + 1;
        L[L[0]] = i;
    }

    static void delete(int[] L, int index) {
        L[index] = L[L[0]];
        L[0] = L[0] - 1;
    }

    static void promotionadd(int[] l, int from, int to) {
        int[] choice = new int[]{12, 8, 6, 10};
        for (int i = 0; i < 4; ++i) {
            chessboard.add(l, chessboard.newmove(from, to, choice[i]));
        }
    }

    void addpawnmoves(int[] list, int side, int f) {
        int lastline;
        int firstline;
        int forward;
        if (side == 0) {
            forward = 12;
            firstline = 3;
            lastline = 8;
        } else {
            forward = -12;
            firstline = 8;
            lastline = 3;
        }
        if (f / 12 == lastline) {
            if (this.getside(f + forward) == -1) {
                chessboard.promotionadd(list, f, f + forward);
            }
            if (this.inboard(f + forward + 1) && this.getside(f + forward + 1) == 1 - side) {
                chessboard.promotionadd(list, f, f + forward + 1);
            }
            if (this.inboard(f + forward - 1) && this.getside(f + forward - 1) == 1 - side) {
                chessboard.promotionadd(list, f, f + forward - 1);
            }
            return;
        }
        if (this.getside(f + forward) == -1) {
            chessboard.add(list, chessboard.newmove(f, f + forward));
            if (f / 12 == firstline && this.getside(f + 2 * forward) == -1) {
                chessboard.add(list, chessboard.newmove(f, f + 2 * forward));
            }
        }
        if (this.inboard(f + forward + 1) && this.getside(f + forward + 1) == 1 - side) {
            chessboard.add(list, chessboard.newmove(f, f + forward + 1));
        }
        if (this.inboard(f + forward - 1) && this.getside(f + forward - 1) == 1 - side) {
            chessboard.add(list, chessboard.newmove(f, f + forward - 1));
        }
    }

    void addjumpmoves(int[] list, int side, int f, int[] jump) {
        for (int i = 0; i < 8; ++i) {
            if (!this.inboard(f + jump[i]) || this.getside(f + jump[i]) == side) continue;
            chessboard.add(list, chessboard.newmove(f, f + jump[i]));
        }
    }

    void addslidemoves(int[] list, int side, int f, int dir) {
        int x = f;
        for (int i = 0; i < 7 && this.inboard(x += dir) && this.getside(x) != side; ++i) {
            chessboard.add(list, chessboard.newmove(f, x));
            if (this.getside(x) == 1 - side) break;
        }
    }

    boolean check(int side) {
        int f = this.getking(side);
        if (f == -1) {
            return false;
        }
        return this.attack(f, 1 - side);
    }

    boolean illmovedone() {
        return this.check(1 - this.getside());
    }

    int[] listofmoves() {
        int[] list = this.listofpseudomoves();
        int m = 1;
        while (m <= list[0]) {
            this.domove(list[m]);
            boolean c = this.illmovedone();
            this.undomove();
            if (c) {
                chessboard.delete(list, m);
                continue;
            }
            ++m;
        }
        return list;
    }

    int[] listofpseudomoves() {
        int row;
        int[] list = chessboard.newlist();
        if (this.status != 3 && this.status != 1) {
            return list;
        }
        int side = this.getside();
        block8: for (int i = 0; i < 144; ++i) {
            if (!this.inboard(i) || this.getside(i) != this.getside()) continue;
            switch (this.getpiece(i)) {
                case 2: {
                    this.addpawnmoves(list, side, i);
                    continue block8;
                }
                case 8: {
                    this.addjumpmoves(list, side, i, knightjump);
                    continue block8;
                }
                case 14: {
                    this.addjumpmoves(list, side, i, kingjump);
                    continue block8;
                }
                case 6: {
                    int d;
                    for (d = 0; d < 4; ++d) {
                        this.addslidemoves(list, side, i, rookdir[d]);
                    }
                    continue block8;
                }
                case 10: {
                    int d;
                    for (d = 0; d < 4; ++d) {
                        this.addslidemoves(list, side, i, bisshopdir[d]);
                    }
                    continue block8;
                }
                case 12: {
                    int d;
                    for (d = 0; d < 4; ++d) {
                        this.addslidemoves(list, side, i, rookdir[d]);
                        this.addslidemoves(list, side, i, bisshopdir[d]);
                    }
                    continue block8;
                }
                default: {
                    continue block8;
                }
            }
        }
        int n = row = side == 0 ? 24 : 108;
        if (this.getfresh(row + 6)) {
            if (this.getfresh(row + 2) && this.getside(row + 3) == -1 && this.getside(row + 4) == -1 && this.getside(row + 5) == -1 && !this.attack(row + 4, 1 - side) && !this.attack(row + 5, 1 - side) && !this.attack(row + 6, 1 - side)) {
                chessboard.add(list, chessboard.newmove(row + 6, row + 4, 7));
            }
            if (this.getfresh(row + 9) && this.getside(row + 7) == -1 && this.getside(row + 8) == -1 && !this.attack(row + 6, 1 - side) && !this.attack(row + 7, 1 - side) && !this.attack(row + 8, 1 - side)) {
                chessboard.add(list, chessboard.newmove(row + 6, row + 8, 5));
            }
        }
        if (this.moves != 0) {
            int forward = side == 0 ? 12 : -12;
            int m = this.getstoredm(this.moves - 1);
            int to = chessboard.moveto(m);
            int from = chessboard.movefrom(m);
            if (this.getpiece(to) == 2 && from - to == 2 * forward) {
                if (this.inboard(to + 1) && this.getside(to + 1) == side && this.getpiece(to + 1) == 2 && this.getside(to + forward) == -1) {
                    chessboard.add(list, chessboard.newmove(to + 1, to + forward, 3));
                }
                if (this.inboard(to - 1) && this.getside(to - 1) == side && this.getpiece(to - 1) == 2 && this.getside(to + forward) == -1) {
                    chessboard.add(list, chessboard.newmove(to - 1, to + forward, 3));
                }
            }
        }
        return list;
    }

    static {
        OUT = 8888;
        VOID = -1;
        PAWN = 2;
        ROOK = 6;
        KNIGHT = 8;
        BISSHOP = 10;
        QUEEN = 12;
        KING = 14;
        FRESHKING = 114;
        FRESHROOK = 106;
        ENPASSANT = 3;
        CASTLE = 5;
        CAASTLE = 7;
        WHITE = 0;
        BLACK = 1;
        oldmovesize = 64;
        maxlistsize = 80;
        CHECKMATE = 0;
        CHECK = 1;
        DRAW = 2;
        OPEN = 3;
        knightjump = new int[]{-10, 10, -14, 14, -23, 23, -25, 25};
        kingjump = new int[]{-1, 1, -13, -12, -11, 13, 12, 11};
        bisshopdir = new int[]{13, -13, 11, -11};
        rookdir = new int[]{1, -1, 12, -12};
        NULLMOVE = 0;
    }
}

