/*
 * Decompiled with CFR 0.152.
 */
package jchessmid;

import jchessmid.chessboard;
import jchessmid.simplechess;

class mover {
    chessboard original;
    chessboard b;
    static int minlevel = 2;
    static int maxlevel = 6;
    simplechess applet;
    static final int HIGH = 65534;
    static final int SUPERHIGH = 65535;
    static final int ABOVEALL = 65536;
    static int[] pawnscore;
    public int nodes;

    mover(chessboard bb, simplechess l) {
        mover.makepawntable();
        this.original = bb;
        this.applet = l;
    }

    static void makepawntable() {
        int i;
        if (pawnscore != null) {
            return;
        }
        pawnscore = new int[144];
        for (i = 0; i < 144; ++i) {
            mover.pawnscore[i] = 100 + 5 * ((i - 2) / 12);
        }
        for (i = 0; i < 12; ++i) {
            mover.pawnscore[96 + i] = 240;
            mover.pawnscore[84 + i] = 160;
        }
        mover.pawnscore[77] = 180;
        mover.pawnscore[78] = 180;
        mover.pawnscore[65] = 180;
        mover.pawnscore[66] = 180;
    }

    void swap(int[] l, int[] v, int i, int j) {
        int dummy = l[i];
        l[i] = l[j];
        l[j] = dummy;
        dummy = v[i];
        v[i] = v[j];
        v[j] = dummy;
    }

    void sort(int[] l, int[] v) {
        this.quicksort(l, v, 1, l[0]);
    }

    void quicksort(int[] l, int[] v, int p, int r) {
        if (p < r) {
            int q = this.partition(l, v, p, r);
            this.quicksort(l, v, p, q);
            this.quicksort(l, v, q + 1, r);
        }
    }

    int partition(int[] l, int[] v, int p, int r) {
        int x = v[p];
        int i = p - 1;
        int j = r + 1;
        while (true) {
            if (v[--j] < x) {
                continue;
            }
            while (v[++i] > x) {
            }
            if (i >= j) break;
            this.swap(l, v, i, j);
        }
        return j;
    }

    int[] estimates(int[] l) {
        int[] v = new int[l[0] + 1];
        v[0] = l[0];
        for (int i = 1; i <= l[0]; ++i) {
            if (l[i] == 0) {
                v[i] = 0;
                continue;
            }
            int np = chessboard.movenewpiece(l[i]);
            if (np == 0) {
                v[i] = this.value(this.b.getpiece(chessboard.moveto(l[i])));
            }
            if (np == 3) {
                v[i] = 110;
                continue;
            }
            if (np == 5) {
                v[i] = 20;
                continue;
            }
            v[i] = np == 7 ? 16 : this.value(np);
        }
        return v;
    }

    int[] makefulllist() {
        int[] l = this.b.listofmoves();
        int[] v = this.estimates(l);
        this.sort(l, v);
        return l;
    }

    int fullsearch(int alpha, int beta, int level) {
        if (level >= minlevel) {
            return this.justattacksearch(alpha, beta, level);
        }
        ++this.nodes;
        int[] list = this.makefulllist();
        if (list[0] == 0) {
            if (this.b.check(this.b.getside())) {
                return -65534;
            }
            return 0;
        }
        for (int c = 1; c <= list[0]; ++c) {
            this.b.domove(list[c]);
            int s = -this.fullsearch(-beta, -alpha, level + 1);
            this.b.undomove();
            if (s > beta) {
                return s;
            }
            if (s <= alpha) continue;
            alpha = s;
        }
        return alpha;
    }

    int[] makejustattacklist() {
        int[] l = this.b.listofpseudomoves();
        int[] v = this.estimates(l);
        int i = 1;
        while (i <= l[0]) {
            if (v[i] < 50) {
                chessboard.delete(l, i);
                continue;
            }
            ++i;
        }
        chessboard.add(l, 0);
        return l;
    }

    int justattacksearch(int alpha, int beta, int level) {
        ++this.nodes;
        if (level >= maxlevel) {
            return this.justbacksearch(alpha, beta);
        }
        int[] list = this.makejustattacklist();
        for (int c = 1; c <= list[0]; ++c) {
            this.b.domove(list[c]);
            int s = -this.justattacksearch(-beta, -alpha, level + 1);
            this.b.undomove();
            if (s > beta) {
                return s;
            }
            if (s <= alpha) continue;
            alpha = s;
        }
        return alpha;
    }

    int value(int piece) {
        if (piece == 2) {
            return 105;
        }
        if (piece == 8) {
            return 300;
        }
        if (piece == 6) {
            return 500;
        }
        if (piece == 12) {
            return 900;
        }
        if (piece == 10) {
            return 320;
        }
        if (piece == 14) {
            return 3200;
        }
        if (piece == -1) {
            return 0;
        }
        return 0;
    }

    int justbacksearch(int alpha, int beta) {
        if (this.b.illmovedone()) {
            return 65536;
        }
        int to = chessboard.moveto(this.b.getstoredm(this.b.moves - 1));
        int s = this.basicscore();
        if (s > beta) {
            return s;
        }
        if (s > alpha) {
            alpha = s;
        }
        if (this.b.attack(to, this.b.getside())) {
            int[] list = this.hitbacklist();
            for (int c = 1; c <= list[0]; ++c) {
                this.b.domove(list[c]);
                s = -this.justbacksearch(-beta, -alpha);
                this.b.undomove();
                if (s > beta) {
                    return s;
                }
                if (s <= alpha) continue;
                alpha = s;
            }
        }
        return alpha;
    }

    int[] hitbacklist() {
        int[] l = this.b.listofpseudomoves();
        int to = chessboard.moveto(this.b.getstoredm(this.b.moves - 1));
        int i = 1;
        while (i <= l[0]) {
            if (chessboard.moveto(l[i]) != to) {
                chessboard.delete(l, i);
                continue;
            }
            ++i;
        }
        chessboard.add(l, 0);
        return l;
    }

    int basicscore() {
        int[] score = new int[2];
        for (int x = 24; x < 120; x += 12) {
            block9: for (int field = x + 2; field < x + 10; ++field) {
                int pside = this.b.getside(field);
                if (pside == -1) continue;
                switch (this.b.getpiece(field)) {
                    case 2: {
                        if (pside == 0) {
                            int n = pside;
                            score[n] = score[n] + pawnscore[field];
                        } else {
                            int n = pside;
                            score[n] = score[n] + pawnscore[144 - field];
                        }
                        if (this.b.A[field + 12] != 2 + pside) continue block9;
                        int n = pside;
                        score[n] = score[n] - 20;
                        continue block9;
                    }
                    case 8: {
                        int n = pside;
                        score[n] = score[n] + 280;
                        continue block9;
                    }
                    case 10: {
                        int n = pside;
                        score[n] = score[n] + 300;
                        continue block9;
                    }
                    case 6: {
                        int n = pside;
                        score[n] = score[n] + 500;
                        continue block9;
                    }
                    case 12: {
                        int n = pside;
                        score[n] = score[n] + 900;
                        continue block9;
                    }
                    case 14: {
                        int n = pside;
                        score[n] = score[n] + 3200;
                    }
                }
            }
        }
        int whiteresult = score[0] - score[1];
        return this.b.getside() == 0 ? whiteresult : -whiteresult;
    }

    static {
        HIGH = 65534;
        SUPERHIGH = 65535;
        ABOVEALL = 65536;
    }
}

