/*
 * Decompiled with CFR 0.152.
 */
package skiing;

import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import skiing.Gates;
import skiing.Skier;
import skiing.Tree;

public class SkiCourt
extends Canvas
implements CommandListener,
Runnable {
    Random random = new Random();
    private static final int MAX_DELAY = 80;
    private static final int MIN_DELAY = 5;
    private static final int DEFAULT_DELAY = 50;
    private static final int MAX_TREES = 10;
    private static final int MAX_GATES = 2;
    private static final int MAX_NUMBER_OF_GATES = 10;
    private long startTime = -1L;
    private long currentTime = -1L;
    private long startMenuTime;
    private long stopMenuTime = -1L;
    private Command startCommand = new Command("Start", 1, 1);
    private Command stopCommand = new Command("Finished", 1, 1);
    private CommandListener commandListener;
    private int delay = 50;
    private int bonusTime = 0;
    private int numberOfGates = 0;
    private int width = this.getWidth();
    private int height = this.getHeight() - Font.getDefaultFont().getHeight();
    private boolean stopped = true;
    private boolean paused = true;
    private Gates[] gates;
    private Skier skier;
    private Tree[] tree;

    public SkiCourt(Display display) {
        this.initialization();
        this.addCommand(this.startCommand);
        this.addCommand(this.stopCommand);
        super.setCommandListener((CommandListener)this);
    }

    boolean addGates(boolean bl) {
        int n = 0;
        while (n < this.gates.length) {
            if (!this.gates[n].inPlay()) {
                if (this.yLastGate() < this.height / 3 && this.yLastGate() != -1) {
                    ++this.numberOfGates;
                    if (this.numberOfGates < 10) {
                        this.gates[n].putInPlay(bl);
                        if (this.stopped) {
                            this.repaint();
                        }
                        return true;
                    }
                    this.gates[n].putFinishLine();
                }
                return false;
            }
            ++n;
        }
        return false;
    }

    void addTree() {
        int n = 0;
        while (n < this.tree.length) {
            if (!this.tree[n].inPlay()) {
                this.tree[n].putInPlay();
                if (this.stopped) {
                    this.repaint();
                }
                return;
            }
            ++n;
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.startCommand) {
            this.startGame();
        }
        if (command == this.stopCommand) {
            this.stopGame();
        }
        this.commandListener.commandAction(command, displayable);
    }

    void destroy() {
        this.pause();
        this.startMenuTime = System.currentTimeMillis();
    }

    private void displayTime(Graphics graphics) {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        this.currentTime = System.currentTimeMillis();
        l = this.currentTime - this.startTime;
        l2 = l / 1000L;
        l3 = (l - l2 * 1000L) / 100L;
        String string = "";
        string = String.valueOf(l2 += (long)this.bonusTime);
        String string2 = "";
        string2 = String.valueOf(l3);
        graphics.setColor(0, 0, 0);
        graphics.drawString(String.valueOf(string) + "." + string2, 0, this.getHeight(), 36);
    }

    protected void hideNotify() {
        this.pause();
    }

    void hitGrbina() {
        int n = 0;
        while (n < this.gates.length) {
            if (this.gates[n].inPlay()) {
                int n2 = 0;
                while (n2 < this.gates[n].grbina.length) {
                    int n3;
                    if (!this.gates[n].grbina[n2].getHit() && (n3 = this.gates[n].grbina[n2].isHit(this.skier.getX(), this.skier.getY(), this.skier.getXSize(), this.skier.getYSize())) < 2) {
                        this.skier.setX(n3);
                        this.repaint();
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    void initialization() {
        this.bonusTime = 0;
        this.numberOfGates = 0;
        this.startTime = -1L;
        this.currentTime = -1L;
        this.delay = 50;
        this.gates = new Gates[2];
        this.skier = new Skier(this, this.width / 2, 0, 0, this.width);
        this.tree = new Tree[10];
        int n = 0;
        while (n < 10) {
            this.tree[n] = new Tree(this, 0, 0, this.width, this.height);
            ++n;
        }
        int n2 = 0;
        while (n2 < 2) {
            this.gates[n2] = new Gates(this, 0, 0, this.width, this.height);
            ++n2;
        }
    }

    public void keyPressed(int n) {
        if (this.stopped) {
            return;
        }
        int n2 = this.getGameAction(n);
        switch (n2) {
            case 2: {
                this.skier.left();
                this.repaint();
                break;
            }
            case 5: {
                this.skier.right();
                this.repaint();
                break;
            }
            case 1: {
                this.slowDownGame();
                break;
            }
            case 6: {
                this.speedUpGame();
            }
        }
    }

    public void keyRepeated(int n) {
        this.keyPressed(n);
    }

    void missedGate() {
        int n = 0;
        while (n < this.gates.length) {
            if (!this.gates[n].getMissed() && this.gates[n].inPlay() && this.gates[n].isMissed(this.skier.getX(), this.skier.getY(), this.skier.getXSize(), this.skier.getYSize())) {
                this.bonusTime += 10;
                this.repaint();
                return;
            }
            ++n;
        }
    }

    protected void paint(Graphics graphics) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        int n = 0;
        while (n < 2) {
            this.gates[n].paint(graphics);
            ++n;
        }
        int n2 = 0;
        while (n2 < 10) {
            this.tree[n2].paint(graphics);
            ++n2;
        }
        if (this.startTime != -1L) {
            this.displayTime(graphics);
        }
        this.skier.paint(graphics);
    }

    void pause() {
        this.paused = true;
    }

    public void run() {
        this.paused = false;
        boolean bl = true;
        while (!this.paused) {
            this.repaint();
            try {
                Thread.currentThread();
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {}
            int n = 0;
            while (n < this.tree.length) {
                this.tree[n].moveUp();
                ++n;
            }
            int n2 = 0;
            while (n2 < this.gates.length) {
                this.gates[n2].moveUp();
                ++n2;
            }
            if ((this.random.nextInt() >>> 1) % 50 == 10) {
                this.addTree();
            }
            if (this.numberOfGates < 10 && (this.random.nextInt() >>> 1) % 5 == 2 && this.addGates(bl)) {
                bl = !bl;
            }
            this.treeHit();
            this.missedGate();
            this.hitGrbina();
            int n3 = 0;
            while (n3 < this.gates.length) {
                if (this.gates[n3].finished(this.skier.getY(), this.skier.getYSize())) {
                    this.stopGame();
                }
                ++n3;
            }
        }
    }

    public void setCommandListener(CommandListener commandListener) {
        this.commandListener = commandListener;
    }

    protected void showNotify() {
        if (this.stopMenuTime == -1L) {
            this.start();
            return;
        }
        this.stopMenuTime = System.currentTimeMillis();
        long l = this.stopMenuTime - this.startMenuTime;
        this.startTime -= l;
        this.start();
    }

    void slowDownGame() {
        this.delay += 10;
        if (this.delay > 80) {
            this.delay = 80;
        }
    }

    void speedUpGame() {
        this.delay -= 10;
        if (this.delay < 5) {
            this.delay = 5;
        }
    }

    void start() {
        if (this.stopped) {
            return;
        }
        Thread thread = new Thread(this);
        thread.start();
    }

    void startGame() {
        if (!this.stopped) {
            return;
        }
        this.removeCommand(this.startCommand);
        this.addCommand(this.stopCommand);
        this.initialization();
        this.stopped = false;
        this.startTime = System.currentTimeMillis();
        this.start();
    }

    void stopGame() {
        this.removeCommand(this.stopCommand);
        this.addCommand(this.startCommand);
        this.stopped = true;
        this.pause();
    }

    void treeHit() {
        int n = 0;
        while (n < this.tree.length) {
            if (!this.tree[n].getHit() && this.tree[n].isHit(this.skier.getX(), this.skier.getY(), this.skier.getXSize(), this.skier.getYSize())) {
                this.bonusTime += 5;
                this.repaint();
            }
            ++n;
        }
    }

    int yLastGate() {
        int n = -1;
        int n2 = 0;
        while (n2 < this.gates.length) {
            if (this.gates[n2].getYPos() > n) {
                n = this.gates[n2].getYPos();
            }
            ++n2;
        }
        return n;
    }
}

