/*
 * Decompiled with CFR 0.152.
 */
package org.cesar.inmotion.sea;

import java.io.IOException;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import org.cesar.inmotion.sea.Constants;
import org.cesar.inmotion.sea.GameCanvas;
import org.cesar.inmotion.sea.SeaPersistence;
import org.cesar.inmotion.util.AbstractMIDlet;
import org.cesar.inmotion.util.ApplicationController;

public class GameController
extends ApplicationController
implements Runnable {
    public static final int GAME_CANVAS = 1;
    public static final int EXIT_DIALOG = 2;
    public static final int GAMEOVER_SCREEN = 3;
    public static final int PRESENTATION_MENU = 4;
    public static final int HI_SCORE = 5;
    public static final int CONGRATULATIONS = 6;
    private Displayable presentationScreen;
    private GameCanvas gameCanvas;
    private int refreshRate;

    public void setFps(int n) {
        this.refreshRate = 1000 / n;
    }

    public void paintGameOver() {
        ApplicationController.getInstance(AbstractMIDlet.getAppClassName()).changeScreen(3);
    }

    public void run() {
        if (!this.gameCanvas.isGameOver()) {
            if (!this.gameCanvas.isPaused()) {
                this.gameCanvas.update();
                this.gameCanvas.repaint();
                this.gameCanvas.serviceRepaints();
            }
            AbstractMIDlet.getDisplay().callSerially((Runnable)this);
        }
    }

    public Displayable getPresentationScreen() {
        return this.presentationScreen;
    }

    public void setPresentationScreen(Displayable displayable) {
        this.presentationScreen = displayable;
    }

    public GameCanvas getGameCanvas() {
        return this.gameCanvas;
    }

    public void startAppAction() {
        ApplicationController.getInstance(AbstractMIDlet.getAppClassName()).changeScreen(-11);
    }

    public void processAction(int n) {
        switch (n) {
            case 0: {
                this.gameCanvas.init();
                Constants.lives = (byte)5;
                Thread thread = new Thread(this);
                thread.start();
                ApplicationController.getInstance(AbstractMIDlet.getAppClassName()).changeScreen(1);
                break;
            }
            case 1: {
                this.writeHiScore();
                ApplicationController.getInstance(AbstractMIDlet.getAppClassName()).changeScreen(5);
            }
        }
    }

    public void paintScreen(String string, Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(graphics.getClipX(), graphics.getClipY(), graphics.getClipWidth(), graphics.getClipHeight());
        try {
            Image image = Image.createImage((String)string);
            graphics.drawImage(image, 0, 0, 20);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void setGameCanvas(GameCanvas gameCanvas) {
        this.gameCanvas = gameCanvas;
    }

    public void writeHiScore() {
        String string = "";
        Form form = (Form)ApplicationController.getInstance(AbstractMIDlet.getAppClassName()).getScreen(5);
        int n = 0;
        while (n < SeaPersistence.getInstance().getScoreNumber()) {
            string = string + SeaPersistence.getInstance().getScoreName(n) + " " + SeaPersistence.getInstance().getScoreValue(n) + "\n";
            ++n;
        }
        if (form.size() != 0) {
            form.delete(0);
        }
        form.append(string);
    }
}

