/*
 * Decompiled with CFR 0.152.
 */
package org.cesar.inmotion.sea;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import org.cesar.inmotion.sea.Constants;
import org.cesar.inmotion.sea.GameCanvas;
import org.cesar.inmotion.sea.GameController;
import org.cesar.inmotion.sea.SeaPersistence;
import org.cesar.inmotion.util.AbstractMIDlet;
import org.cesar.inmotion.util.ApplicationController;

public class GameMIDlet
extends AbstractMIDlet {
    private static final String FILE_PATH = "/org/cesar/inmotion/sea/res/splash.png";
    private static final String CONTROLLER_FILE_PATH = "org.cesar.inmotion.sea.GameController";

    public GameMIDlet() {
        this.setDisplay(Display.getDisplay((MIDlet)this));
    }

    public void startApp() {
        PresentationMenu presentationMenu = new PresentationMenu();
        AbstractMIDlet.setAppClassName(CONTROLLER_FILE_PATH);
        ApplicationController applicationController = ApplicationController.getInstance(AbstractMIDlet.getAppClassName());
        GameCanvas gameCanvas = new GameCanvas();
        ((GameController)applicationController).setGameCanvas(gameCanvas);
        Form form = new Form(Constants.GAME_TITLE);
        form.append(Constants.exitGameMessage);
        form.addCommand(Constants.noCommand);
        form.addCommand(Constants.yesCommand);
        form.setCommandListener((CommandListener)gameCanvas);
        Form form2 = new Form(Constants.BEST_SCORE_STR);
        form2.addCommand(Constants.emptyCommand);
        form2.addCommand(Constants.backCommand);
        form2.setCommandListener((CommandListener)gameCanvas);
        Form form3 = new Form(Constants.CONGRATULATIONS_STR);
        form3.addCommand(Constants.okCommand);
        form3.addCommand(Constants.emptyCommand);
        form3.append((Item)new TextField(Constants.NAMES_STR, "", 3, 0));
        form3.setCommandListener((CommandListener)gameCanvas);
        applicationController.addScreen(4, (Displayable)presentationMenu);
        applicationController.addScreen(1, (Displayable)gameCanvas);
        applicationController.addScreen(2, (Displayable)form);
        applicationController.addScreen(5, (Displayable)form2);
        applicationController.addScreen(6, (Displayable)form3);
        applicationController.changeScreen(4);
        SeaPersistence.getInstance().load();
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
        SeaPersistence.getInstance().save();
    }

    class PresentationMenu
    extends Canvas
    implements CommandListener {
        private byte index;
        private byte lastIndex;

        public PresentationMenu() {
            this.addCommand(Constants.okCommand);
            this.addCommand(Constants.exitCommand);
            this.setCommandListener(this);
        }

        protected void showNotify() {
        }

        public void paint(Graphics graphics) {
            graphics.setColor(255, 255, 255);
            graphics.fillRect(0, 0, graphics.getClipWidth(), graphics.getClipHeight());
            short s = (short)(graphics.getClipWidth() / 2 - Constants.splashImg.getWidth() / 2);
            short s2 = (short)(graphics.getClipHeight() / 2 - Constants.splashImg.getHeight() / 2);
            graphics.drawImage(Constants.splashImg, (int)s, (int)s2, 20);
            graphics.drawImage(Constants.img_arrow, s + 74, s2 + 26 + 12 * this.index, 20);
        }

        public void keyPressed(int n) {
            int n2 = this.getGameAction(n);
            switch (n2) {
                case 6: {
                    this.index = this.index != 2 ? (this.index = (byte)(this.index + 1)) : this.index;
                    break;
                }
                case 1: {
                    this.index = this.index != 0 ? (this.index = (byte)(this.index - 1)) : this.index;
                    break;
                }
            }
            this.repaint();
            this.serviceRepaints();
        }

        public void commandAction(Command command, Displayable displayable) {
            ApplicationController applicationController = ApplicationController.getInstance(AbstractMIDlet.getAppClassName());
            if (command == Constants.okCommand) {
                applicationController.processAction(this.index);
            } else if (command == Constants.exitCommand) {
                GameMIDlet.this.destroyApp(false);
                GameMIDlet.this.notifyDestroyed();
            }
        }
    }
}

