/*
 * Decompiled with CFR 0.152.
 */
package org.cesar.inmotion.util;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class GameItem {
    private int x;
    private int y;
    private int xspeed;
    private int yspeed;
    private boolean visible;
    private Image image;
    private int height;
    private int width;

    public GameItem(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public GameItem(int n, int n2, Image image) {
        this.image = image;
        this.x = n;
        this.y = n2;
        if (this.image == null) {
            this.height = 0;
            this.width = 0;
        } else {
            this.height = this.image.getHeight();
            this.width = this.image.getWidth();
        }
    }

    private boolean rectangleIntersection(int n, int n2, int n3, int n4) {
        if (this.getY() + this.getHeight() - 1 < n3) {
            return false;
        }
        if (this.getY() > n4) {
            return false;
        }
        if (this.getX() + this.getWidth() - 1 < n) {
            return false;
        }
        return this.getX() <= n2;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public Image getImage() {
        return this.image;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setX(int n) {
        this.x = n;
    }

    public void setY(int n) {
        this.y = n;
    }

    public int getXspeed() {
        return this.xspeed;
    }

    public void setXspeed(int n) {
        this.xspeed = n;
    }

    public int getYspeed() {
        return this.yspeed;
    }

    public void setYspeed(int n) {
        this.yspeed = n;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public abstract void draw(Graphics var1);

    public abstract void update();

    public boolean intersects(GameItem gameItem) {
        boolean bl = false;
        if (this.isVisible()) {
            bl = this.rectangleIntersection(gameItem.getX(), gameItem.getX() + gameItem.getWidth() - 1, gameItem.getY(), gameItem.getY() + gameItem.getHeight() - 1);
        }
        return bl;
    }
}

