/*
 * Decompiled with CFR 0.152.
 */
package org.cesar.inmotion.util;

import org.cesar.inmotion.util.GameItem;

public class ObjectSet {
    private int elementCount;
    private int activeCount;
    private GameItem[] elementData;

    public ObjectSet() {
        this(10);
    }

    public ObjectSet(int n) {
        this.elementData = new GameItem[n];
        this.elementCount = 0;
    }

    public boolean add(GameItem gameItem) {
        this.add(this.elementCount, gameItem);
        return true;
    }

    public void add(int n, GameItem gameItem) {
        if (n > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException("ArrayList: index > elementCount");
        }
        this.ensureCapacity(this.elementCount + 1);
        if (n < this.elementCount) {
            System.arraycopy(this.elementData, n, this.elementData, n + 1, this.elementCount - n);
        }
        this.elementData[n] = gameItem;
        ++this.elementCount;
    }

    public void clear() {
        this.elementCount = 0;
        this.elementData = new GameItem[this.elementData.length];
    }

    public boolean contains(GameItem gameItem) {
        boolean bl = false;
        int n = 0;
        while (n < this.elementCount) {
            if (gameItem == null ? this.elementData[n] == null : gameItem.equals(this.elementData[n])) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    public void ensureCapacity(int n) {
        if (this.elementData.length >= n) {
            return;
        }
        int n2 = 2 * this.elementData.length;
        if (n2 < n) {
            n2 = n;
        }
        GameItem[] gameItemArray = new GameItem[n2];
        System.arraycopy(this.elementData, 0, gameItemArray, 0, this.elementCount);
        this.elementData = gameItemArray;
    }

    public GameItem getByIndex(int n) {
        if (n < this.elementCount) {
            return this.elementData[n];
        }
        return null;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public void remove(int n) {
        if (n == this.elementCount - 1) {
            this.elementData[n] = null;
        } else {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, this.elementCount - (n + 1));
            this.elementData[this.elementCount - 1] = null;
        }
        --this.elementCount;
    }

    public GameItem set(int n, GameItem gameItem) {
        GameItem gameItem2 = this.elementData[n];
        this.elementData[n] = gameItem;
        return gameItem2;
    }

    public int size() {
        return this.elementCount;
    }

    public void trimToSize() {
        GameItem[] gameItemArray = new GameItem[this.elementCount];
        System.arraycopy(this.elementData, 0, gameItemArray, 0, this.elementCount);
        this.elementData = gameItemArray;
    }
}

